/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentFilterKey {
    NAME("Name"),
    OWNER("Owner"),
    PLATFORM_TYPES("PlatformTypes"),
    DOCUMENT_TYPE("DocumentType"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentFilterKey.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentFilterKey> knownValues() {
        return Stream.of(DocumentFilterKey.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

