/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMaintenanceWindowExecutionTaskInvocationResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationResponse> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::windowExecutionId)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::windowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()}).build();
    private static final SdkField<String> TASK_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::taskExecutionId)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::taskExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionId").build()}).build();
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::invocationId)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationId").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::executionId)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::taskTypeAsString)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::parameters)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::statusAsString)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::statusDetails)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::startTime)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::endTime)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::ownerInformation)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::ownerInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()}).build();
    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowExecutionTaskInvocationResponse.getter(GetMaintenanceWindowExecutionTaskInvocationResponse::windowTargetId)).setter(GetMaintenanceWindowExecutionTaskInvocationResponse.setter(Builder::windowTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD, TASK_EXECUTION_ID_FIELD, INVOCATION_ID_FIELD, EXECUTION_ID_FIELD, TASK_TYPE_FIELD, PARAMETERS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, START_TIME_FIELD, END_TIME_FIELD, OWNER_INFORMATION_FIELD, WINDOW_TARGET_ID_FIELD));
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String invocationId;
    private final String executionId;
    private final String taskType;
    private final String parameters;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;
    private final String ownerInformation;
    private final String windowTargetId;

    private GetMaintenanceWindowExecutionTaskInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.invocationId = builder.invocationId;
        this.executionId = builder.executionId;
        this.taskType = builder.taskType;
        this.parameters = builder.parameters;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ownerInformation = builder.ownerInformation;
        this.windowTargetId = builder.windowTargetId;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public String executionId() {
        return this.executionId;
    }

    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public String taskTypeAsString() {
        return this.taskType;
    }

    public String parameters() {
        return this.parameters;
    }

    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskInvocationResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskInvocationResponse other = (GetMaintenanceWindowExecutionTaskInvocationResponse)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskExecutionId(), other.taskExecutionId()) && Objects.equals(this.invocationId(), other.invocationId()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.windowTargetId(), other.windowTargetId());
    }

    public String toString() {
        return ToString.builder((String)"GetMaintenanceWindowExecutionTaskInvocationResponse").add("WindowExecutionId", (Object)this.windowExecutionId()).add("TaskExecutionId", (Object)this.taskExecutionId()).add("InvocationId", (Object)this.invocationId()).add("ExecutionId", (Object)this.executionId()).add("TaskType", (Object)this.taskTypeAsString()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("OwnerInformation", (Object)(this.ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("WindowTargetId", (Object)this.windowTargetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionId()));
            }
            case "TaskExecutionId": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionId()));
            }
            case "InvocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "TaskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "WindowTargetId": {
                return Optional.ofNullable(clazz.cast(this.windowTargetId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMaintenanceWindowExecutionTaskInvocationResponse, T> g) {
        return obj -> g.apply((GetMaintenanceWindowExecutionTaskInvocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String invocationId;
        private String executionId;
        private String taskType;
        private String parameters;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;
        private String ownerInformation;
        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskInvocationResponse model) {
            super(model);
            this.windowExecutionId(model.windowExecutionId);
            this.taskExecutionId(model.taskExecutionId);
            this.invocationId(model.invocationId);
            this.executionId(model.executionId);
            this.taskType(model.taskType);
            this.parameters(model.parameters);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.ownerInformation(model.ownerInformation);
            this.windowTargetId(model.windowTargetId);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getTaskTypeAsString() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskInvocationResponse build() {
            return new GetMaintenanceWindowExecutionTaskInvocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationResponse> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder invocationId(String var1);

        public Builder executionId(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder parameters(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ownerInformation(String var1);

        public Builder windowTargetId(String var1);
    }
}

