/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PatchComplianceDataState {
    INSTALLED("INSTALLED"),
    INSTALLED_OTHER("INSTALLED_OTHER"),
    INSTALLED_PENDING_REBOOT("INSTALLED_PENDING_REBOOT"),
    INSTALLED_REJECTED("INSTALLED_REJECTED"),
    MISSING("MISSING"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    FAILED("FAILED"),
    AVAILABLE_SECURITY_UPDATE("AVAILABLE_SECURITY_UPDATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PatchComplianceDataState> VALUE_MAP;
    private final String value;

    private PatchComplianceDataState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchComplianceDataState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchComplianceDataState> knownValues() {
        EnumSet<PatchComplianceDataState> knownValues = EnumSet.allOf(PatchComplianceDataState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PatchComplianceDataState.class, PatchComplianceDataState::toString);
    }
}

