/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;

public class DescribeInstancePatchStatesPublisher
implements SdkPublisher<DescribeInstancePatchStatesResponse> {
    private final SsmAsyncClient client;
    private final DescribeInstancePatchStatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstancePatchStatesPublisher(SsmAsyncClient client, DescribeInstancePatchStatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstancePatchStatesPublisher(SsmAsyncClient client, DescribeInstancePatchStatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstancePatchStatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstancePatchStatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstancePatchState> instancePatchStates() {
        Function<DescribeInstancePatchStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instancePatchStates() != null) {
                return response.instancePatchStates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstancePatchStatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstancePatchStatesResponseFetcher
    implements AsyncPageFetcher<DescribeInstancePatchStatesResponse> {
        private DescribeInstancePatchStatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancePatchStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstancePatchStatesResponse> nextPage(DescribeInstancePatchStatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancePatchStatesPublisher.this.client.describeInstancePatchStates(DescribeInstancePatchStatesPublisher.this.firstRequest);
            }
            return DescribeInstancePatchStatesPublisher.this.client.describeInstancePatchStates((DescribeInstancePatchStatesRequest)((Object)DescribeInstancePatchStatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

