/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpsItemFilterOperator {
    EQUAL("Equal"),
    CONTAINS("Contains"),
    GREATER_THAN("GreaterThan"),
    LESS_THAN("LessThan"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsItemFilterOperator> VALUE_MAP;
    private final String value;

    private OpsItemFilterOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpsItemFilterOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpsItemFilterOperator> knownValues() {
        EnumSet<OpsItemFilterOperator> knownValues = EnumSet.allOf(OpsItemFilterOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpsItemFilterOperator.class, OpsItemFilterOperator::toString);
    }
}

