/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSharingInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSharingInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountSharingInfo.getter(AccountSharingInfo::accountId)).setter(AccountSharingInfo.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> SHARED_DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedDocumentVersion").getter(AccountSharingInfo.getter(AccountSharingInfo::sharedDocumentVersion)).setter(AccountSharingInfo.setter(Builder::sharedDocumentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDocumentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SHARED_DOCUMENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountSharingInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String sharedDocumentVersion;

    private AccountSharingInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.sharedDocumentVersion = builder.sharedDocumentVersion;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String sharedDocumentVersion() {
        return this.sharedDocumentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedDocumentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSharingInfo)) {
            return false;
        }
        AccountSharingInfo other = (AccountSharingInfo)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.sharedDocumentVersion(), other.sharedDocumentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSharingInfo").add("AccountId", (Object)this.accountId()).add("SharedDocumentVersion", (Object)this.sharedDocumentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "SharedDocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.sharedDocumentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("SharedDocumentVersion", SHARED_DOCUMENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSharingInfo, T> g) {
        return obj -> g.apply((AccountSharingInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String sharedDocumentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSharingInfo model) {
            this.accountId(model.accountId);
            this.sharedDocumentVersion(model.sharedDocumentVersion);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSharedDocumentVersion() {
            return this.sharedDocumentVersion;
        }

        public final void setSharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
        }

        @Override
        public final Builder sharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
            return this;
        }

        public AccountSharingInfo build() {
            return new AccountSharingInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSharingInfo> {
        public Builder accountId(String var1);

        public Builder sharedDocumentVersion(String var1);
    }
}

