/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::name)).setter(CreateMaintenanceWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::description)).setter(CreateMaintenanceWindowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDate").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::startDate)).setter(CreateMaintenanceWindowRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDate").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::endDate)).setter(CreateMaintenanceWindowRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::schedule)).setter(CreateMaintenanceWindowRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleTimezone").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::scheduleTimezone)).setter(CreateMaintenanceWindowRequest.setter(Builder::scheduleTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduleOffset").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::scheduleOffset)).setter(CreateMaintenanceWindowRequest.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::duration)).setter(CreateMaintenanceWindowRequest.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cutoff").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::cutoff)).setter(CreateMaintenanceWindowRequest.setter(Builder::cutoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()}).build();
    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowUnassociatedTargets").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::allowUnassociatedTargets)).setter(CreateMaintenanceWindowRequest.setter(Builder::allowUnassociatedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::clientToken)).setter(CreateMaintenanceWindowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMaintenanceWindowRequest.getter(CreateMaintenanceWindowRequest::tags)).setter(CreateMaintenanceWindowRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, START_DATE_FIELD, END_DATE_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, DURATION_FIELD, CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMaintenanceWindowRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String startDate;
    private final String endDate;
    private final String schedule;
    private final String scheduleTimezone;
    private final Integer scheduleOffset;
    private final Integer duration;
    private final Integer cutoff;
    private final Boolean allowUnassociatedTargets;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String startDate() {
        return this.startDate;
    }

    public final String endDate() {
        return this.endDate;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final String scheduleTimezone() {
        return this.scheduleTimezone;
    }

    public final Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Integer cutoff() {
        return this.cutoff;
    }

    public final Boolean allowUnassociatedTargets() {
        return this.allowUnassociatedTargets;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMaintenanceWindowRequest)) {
            return false;
        }
        CreateMaintenanceWindowRequest other = (CreateMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduleTimezone(), other.scheduleTimezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.allowUnassociatedTargets(), other.allowUnassociatedTargets()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMaintenanceWindowRequest").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Schedule", (Object)this.schedule()).add("ScheduleTimezone", (Object)this.scheduleTimezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("AllowUnassociatedTargets", (Object)this.allowUnassociatedTargets()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduleTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleTimezone()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "AllowUnassociatedTargets": {
                return Optional.ofNullable(clazz.cast(this.allowUnassociatedTargets()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("ScheduleTimezone", SCHEDULE_TIMEZONE_FIELD);
        map.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("Cutoff", CUTOFF_FIELD);
        map.put("AllowUnassociatedTargets", ALLOW_UNASSOCIATED_TARGETS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((CreateMaintenanceWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String startDate;
        private String endDate;
        private String schedule;
        private String scheduleTimezone;
        private Integer scheduleOffset;
        private Integer duration;
        private Integer cutoff;
        private Boolean allowUnassociatedTargets;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMaintenanceWindowRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.schedule(model.schedule);
            this.scheduleTimezone(model.scheduleTimezone);
            this.scheduleOffset(model.scheduleOffset);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.allowUnassociatedTargets(model.allowUnassociatedTargets);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduleTimezone() {
            return this.scheduleTimezone;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return this.allowUnassociatedTargets;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMaintenanceWindowRequest build() {
            return new CreateMaintenanceWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder schedule(String var1);

        public Builder scheduleTimezone(String var1);

        public Builder scheduleOffset(Integer var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder allowUnassociatedTargets(Boolean var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

