/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionPreviewStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCESS("Success"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionPreviewStatus> VALUE_MAP;
    private final String value;

    private ExecutionPreviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionPreviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionPreviewStatus> knownValues() {
        EnumSet<ExecutionPreviewStatus> knownValues = EnumSet.allOf(ExecutionPreviewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionPreviewStatus.class, ExecutionPreviewStatus::toString);
    }
}

