/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTaskFromMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<DeregisterTaskFromMaintenanceWindowResponse.Builder, DeregisterTaskFromMaintenanceWindowResponse> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeregisterTaskFromMaintenanceWindowResponse::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> WINDOW_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeregisterTaskFromMaintenanceWindowResponse::windowTaskId)).setter(setter(Builder::windowTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTaskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD,
            WINDOW_TASK_ID_FIELD));

    private final String windowId;

    private final String windowTaskId;

    private DeregisterTaskFromMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the task was removed from.
     * </p>
     * 
     * @return The ID of the Maintenance Window the task was removed from.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the task removed from the Maintenance Window.
     * </p>
     * 
     * @return The ID of the task removed from the Maintenance Window.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTaskFromMaintenanceWindowResponse)) {
            return false;
        }
        DeregisterTaskFromMaintenanceWindowResponse other = (DeregisterTaskFromMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeregisterTaskFromMaintenanceWindowResponse").add("WindowId", windowId())
                .add("WindowTaskId", windowTaskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.ofNullable(clazz.cast(windowTaskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTaskFromMaintenanceWindowResponse, T> g) {
        return obj -> g.apply((DeregisterTaskFromMaintenanceWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterTaskFromMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window the task was removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the task was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the task removed from the Maintenance Window.
         * </p>
         * 
         * @param windowTaskId
         *        The ID of the task removed from the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTaskFromMaintenanceWindowResponse model) {
            super(model);
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public DeregisterTaskFromMaintenanceWindowResponse build() {
            return new DeregisterTaskFromMaintenanceWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
