/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceDataSyncRequest extends SsmRequest implements
        ToCopyableBuilder<CreateResourceDataSyncRequest.Builder, CreateResourceDataSyncRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceDataSyncRequest::syncName)).setter(setter(Builder::syncName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()).build();

    private static final SdkField<ResourceDataSyncS3Destination> S3_DESTINATION_FIELD = SdkField
            .<ResourceDataSyncS3Destination> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateResourceDataSyncRequest::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(ResourceDataSyncS3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD,
            S3_DESTINATION_FIELD));

    private final String syncName;

    private final ResourceDataSyncS3Destination s3Destination;

    private CreateResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * A name for the configuration.
     * </p>
     * 
     * @return A name for the configuration.
     */
    public String syncName() {
        return syncName;
    }

    /**
     * <p>
     * Amazon S3 configuration details for the sync.
     * </p>
     * 
     * @return Amazon S3 configuration details for the sync.
     */
    public ResourceDataSyncS3Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDataSyncRequest)) {
            return false;
        }
        CreateResourceDataSyncRequest other = (CreateResourceDataSyncRequest) obj;
        return Objects.equals(syncName(), other.syncName()) && Objects.equals(s3Destination(), other.s3Destination());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateResourceDataSyncRequest").add("SyncName", syncName())
                .add("S3Destination", s3Destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.ofNullable(clazz.cast(syncName()));
        case "S3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceDataSyncRequest, T> g) {
        return obj -> g.apply((CreateResourceDataSyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceDataSyncRequest> {
        /**
         * <p>
         * A name for the configuration.
         * </p>
         * 
         * @param syncName
         *        A name for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * <p>
         * Amazon S3 configuration details for the sync.
         * </p>
         * 
         * @param s3Destination
         *        Amazon S3 configuration details for the sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(ResourceDataSyncS3Destination s3Destination);

        /**
         * <p>
         * Amazon S3 configuration details for the sync.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceDataSyncS3Destination.Builder} avoiding
         * the need to create one manually via {@link ResourceDataSyncS3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDataSyncS3Destination.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Destination(ResourceDataSyncS3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link ResourceDataSyncS3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(ResourceDataSyncS3Destination)
         */
        default Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return s3Destination(ResourceDataSyncS3Destination.builder().applyMutation(s3Destination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String syncName;

        private ResourceDataSyncS3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDataSyncRequest model) {
            super(model);
            syncName(model.syncName);
            s3Destination(model.s3Destination);
        }

        public final String getSyncName() {
            return syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDataSyncRequest build() {
            return new CreateResourceDataSyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
