/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentFormat {
    YAML("YAML"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentFormat> knownValues() {
        return Stream.of(DocumentFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

