/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssociationRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateAssociationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::name)).setter(CreateAssociationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::documentVersion)).setter(CreateAssociationRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::instanceId)).setter(CreateAssociationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateAssociationRequest.getter(CreateAssociationRequest::parameters)).setter(CreateAssociationRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateAssociationRequest.getter(CreateAssociationRequest::targets)).setter(CreateAssociationRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::scheduleExpression)).setter(CreateAssociationRequest.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateAssociationRequest.getter(CreateAssociationRequest::outputLocation)).setter(CreateAssociationRequest.setter(Builder::outputLocation)).constructor(InstanceAssociationOutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::associationName)).setter(CreateAssociationRequest.setter(Builder::associationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::maxErrors)).setter(CreateAssociationRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::maxConcurrency)).setter(CreateAssociationRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssociationRequest.getter(CreateAssociationRequest::complianceSeverityAsString)).setter(CreateAssociationRequest.setter(Builder::complianceSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCUMENT_VERSION_FIELD, INSTANCE_ID_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, ASSOCIATION_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD, COMPLIANCE_SEVERITY_FIELD));
    private final String name;
    private final String documentVersion;
    private final String instanceId;
    private final Map<String, List<String>> parameters;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String associationName;
    private final String maxErrors;
    private final String maxConcurrency;
    private final String complianceSeverity;

    private CreateAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.instanceId = builder.instanceId;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.associationName = builder.associationName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public String associationName() {
        return this.associationName;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(this.complianceSeverity);
    }

    public String complianceSeverityAsString() {
        return this.complianceSeverity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSeverityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationRequest)) {
            return false;
        }
        CreateAssociationRequest other = (CreateAssociationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.associationName(), other.associationName()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.complianceSeverityAsString(), other.complianceSeverityAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssociationRequest").add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("InstanceId", (Object)this.instanceId()).add("Parameters", this.parameters()).add("Targets", this.targets()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("AssociationName", (Object)this.associationName()).add("MaxErrors", (Object)this.maxErrors()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ComplianceSeverity", (Object)this.complianceSeverityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "ComplianceSeverity": {
                return Optional.ofNullable(clazz.cast(this.complianceSeverityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssociationRequest, T> g) {
        return obj -> g.apply((CreateAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String documentVersion;
        private String instanceId;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String associationName;
        private String maxErrors;
        private String maxConcurrency;
        private String complianceSeverity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationRequest model) {
            super(model);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.instanceId(model.instanceId);
            this.parameters(model.parameters);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.associationName(model.associationName);
            this.maxErrors(model.maxErrors);
            this.maxConcurrency(model.maxConcurrency);
            this.complianceSeverity(model.complianceSeverity);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getComplianceSeverityAsString() {
            return this.complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity.toString());
            return this;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssociationRequest build() {
            return new CreateAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssociationRequest> {
        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder instanceId(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder associationName(String var1);

        public Builder maxErrors(String var1);

        public Builder maxConcurrency(String var1);

        public Builder complianceSeverity(String var1);

        public Builder complianceSeverity(AssociationComplianceSeverity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

