/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ExecutionInputs;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExecutionPreviewRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, StartExecutionPreviewRequest> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(StartExecutionPreviewRequest.getter(StartExecutionPreviewRequest::documentName)).setter(StartExecutionPreviewRequest.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(StartExecutionPreviewRequest.getter(StartExecutionPreviewRequest::documentVersion)).setter(StartExecutionPreviewRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<ExecutionInputs> EXECUTION_INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionInputs").getter(StartExecutionPreviewRequest.getter(StartExecutionPreviewRequest::executionInputs)).setter(StartExecutionPreviewRequest.setter(Builder::executionInputs)).constructor(ExecutionInputs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionInputs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, EXECUTION_INPUTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentName", DOCUMENT_NAME_FIELD);
            this.put("DocumentVersion", DOCUMENT_VERSION_FIELD);
            this.put("ExecutionInputs", EXECUTION_INPUTS_FIELD);
        }
    });
    private final String documentName;
    private final String documentVersion;
    private final ExecutionInputs executionInputs;

    private StartExecutionPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionInputs = builder.executionInputs;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final ExecutionInputs executionInputs() {
        return this.executionInputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionInputs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionPreviewRequest)) {
            return false;
        }
        StartExecutionPreviewRequest other = (StartExecutionPreviewRequest)((Object)obj);
        return Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.executionInputs(), other.executionInputs());
    }

    public final String toString() {
        return ToString.builder((String)"StartExecutionPreviewRequest").add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("ExecutionInputs", (Object)this.executionInputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "ExecutionInputs": {
                return Optional.ofNullable(clazz.cast(this.executionInputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionPreviewRequest, T> g) {
        return obj -> g.apply((StartExecutionPreviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String documentName;
        private String documentVersion;
        private ExecutionInputs executionInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionPreviewRequest model) {
            super(model);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.executionInputs(model.executionInputs);
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final ExecutionInputs.Builder getExecutionInputs() {
            return this.executionInputs != null ? this.executionInputs.toBuilder() : null;
        }

        public final void setExecutionInputs(ExecutionInputs.BuilderImpl executionInputs) {
            this.executionInputs = executionInputs != null ? executionInputs.build() : null;
        }

        @Override
        public final Builder executionInputs(ExecutionInputs executionInputs) {
            this.executionInputs = executionInputs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExecutionPreviewRequest build() {
            return new StartExecutionPreviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExecutionPreviewRequest> {
        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionInputs(ExecutionInputs var1);

        default public Builder executionInputs(Consumer<ExecutionInputs.Builder> executionInputs) {
            return this.executionInputs((ExecutionInputs)((ExecutionInputs.Builder)ExecutionInputs.builder().applyMutation(executionInputs)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

