/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.InventoryResultItem;
import software.amazon.awssdk.services.ssm.model.InventoryResultItemMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryResultEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryResultEntity> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InventoryResultEntity.getter(InventoryResultEntity::id)).setter(InventoryResultEntity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Map<String, InventoryResultItem>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(InventoryResultEntity.getter(InventoryResultEntity::data)).setter(InventoryResultEntity.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Data", DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Map<String, InventoryResultItem> data;

    private InventoryResultEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public final Map<String, InventoryResultItem> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultEntity)) {
            return false;
        }
        InventoryResultEntity other = (InventoryResultEntity)obj;
        return Objects.equals(this.id(), other.id()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryResultEntity").add("Id", (Object)this.id()).add("Data", this.hasData() ? this.data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InventoryResultEntity, T> g) {
        return obj -> g.apply((InventoryResultEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, InventoryResultItem> data = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultEntity model) {
            this.id(model.id);
            this.data(model.data);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, InventoryResultItem.Builder> getData() {
            Map<String, InventoryResultItem.Builder> result = InventoryResultItemMapCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setData(Map<String, InventoryResultItem.BuilderImpl> data) {
            this.data = InventoryResultItemMapCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
            return this;
        }

        public InventoryResultEntity build() {
            return new InventoryResultEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryResultEntity> {
        public Builder id(String var1);

        public Builder data(Map<String, InventoryResultItem> var1);
    }
}

