/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ManagedStatus;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceInfo> {
    private static final SdkField<String> AGENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentType").getter(InstanceInfo.getter(InstanceInfo::agentType)).setter(InstanceInfo.setter(Builder::agentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentType").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentVersion").getter(InstanceInfo.getter(InstanceInfo::agentVersion)).setter(InstanceInfo.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputerName").getter(InstanceInfo.getter(InstanceInfo::computerName)).setter(InstanceInfo.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceStatus").getter(InstanceInfo.getter(InstanceInfo::instanceStatus)).setter(InstanceInfo.setter(Builder::instanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(InstanceInfo.getter(InstanceInfo::ipAddress)).setter(InstanceInfo.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> MANAGED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedStatus").getter(InstanceInfo.getter(InstanceInfo::managedStatusAsString)).setter(InstanceInfo.setter(Builder::managedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStatus").build()}).build();
    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformType").getter(InstanceInfo.getter(InstanceInfo::platformTypeAsString)).setter(InstanceInfo.setter(Builder::platformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()}).build();
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(InstanceInfo.getter(InstanceInfo::platformName)).setter(InstanceInfo.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(InstanceInfo.getter(InstanceInfo::platformVersion)).setter(InstanceInfo.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(InstanceInfo.getter(InstanceInfo::resourceTypeAsString)).setter(InstanceInfo.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_TYPE_FIELD, AGENT_VERSION_FIELD, COMPUTER_NAME_FIELD, INSTANCE_STATUS_FIELD, IP_ADDRESS_FIELD, MANAGED_STATUS_FIELD, PLATFORM_TYPE_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AgentType", AGENT_TYPE_FIELD);
            this.put("AgentVersion", AGENT_VERSION_FIELD);
            this.put("ComputerName", COMPUTER_NAME_FIELD);
            this.put("InstanceStatus", INSTANCE_STATUS_FIELD);
            this.put("IpAddress", IP_ADDRESS_FIELD);
            this.put("ManagedStatus", MANAGED_STATUS_FIELD);
            this.put("PlatformType", PLATFORM_TYPE_FIELD);
            this.put("PlatformName", PLATFORM_NAME_FIELD);
            this.put("PlatformVersion", PLATFORM_VERSION_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String agentType;
    private final String agentVersion;
    private final String computerName;
    private final String instanceStatus;
    private final String ipAddress;
    private final String managedStatus;
    private final String platformType;
    private final String platformName;
    private final String platformVersion;
    private final String resourceType;

    private InstanceInfo(BuilderImpl builder) {
        this.agentType = builder.agentType;
        this.agentVersion = builder.agentVersion;
        this.computerName = builder.computerName;
        this.instanceStatus = builder.instanceStatus;
        this.ipAddress = builder.ipAddress;
        this.managedStatus = builder.managedStatus;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.resourceType = builder.resourceType;
    }

    public final String agentType() {
        return this.agentType;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String computerName() {
        return this.computerName;
    }

    public final String instanceStatus() {
        return this.instanceStatus;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final ManagedStatus managedStatus() {
        return ManagedStatus.fromValue(this.managedStatus);
    }

    public final String managedStatusAsString() {
        return this.managedStatus;
    }

    public final PlatformType platformType() {
        return PlatformType.fromValue(this.platformType);
    }

    public final String platformTypeAsString() {
        return this.platformType;
    }

    public final String platformName() {
        return this.platformName;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return Objects.equals(this.agentType(), other.agentType()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.instanceStatus(), other.instanceStatus()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.managedStatusAsString(), other.managedStatusAsString()) && Objects.equals(this.platformTypeAsString(), other.platformTypeAsString()) && Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceInfo").add("AgentType", (Object)this.agentType()).add("AgentVersion", (Object)this.agentVersion()).add("ComputerName", (Object)this.computerName()).add("InstanceStatus", (Object)this.instanceStatus()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("ManagedStatus", (Object)this.managedStatusAsString()).add("PlatformType", (Object)this.platformTypeAsString()).add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentType": {
                return Optional.ofNullable(clazz.cast(this.agentType()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatus()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ManagedStatus": {
                return Optional.ofNullable(clazz.cast(this.managedStatusAsString()));
            }
            case "PlatformType": {
                return Optional.ofNullable(clazz.cast(this.platformTypeAsString()));
            }
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInfo, T> g) {
        return obj -> g.apply((InstanceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentType;
        private String agentVersion;
        private String computerName;
        private String instanceStatus;
        private String ipAddress;
        private String managedStatus;
        private String platformType;
        private String platformName;
        private String platformVersion;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            this.agentType(model.agentType);
            this.agentVersion(model.agentVersion);
            this.computerName(model.computerName);
            this.instanceStatus(model.instanceStatus);
            this.ipAddress(model.ipAddress);
            this.managedStatus(model.managedStatus);
            this.platformType(model.platformType);
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.resourceType(model.resourceType);
        }

        public final String getAgentType() {
            return this.agentType;
        }

        public final void setAgentType(String agentType) {
            this.agentType = agentType;
        }

        @Override
        public final Builder agentType(String agentType) {
            this.agentType = agentType;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getInstanceStatus() {
            return this.instanceStatus;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getManagedStatus() {
            return this.managedStatus;
        }

        public final void setManagedStatus(String managedStatus) {
            this.managedStatus = managedStatus;
        }

        @Override
        public final Builder managedStatus(String managedStatus) {
            this.managedStatus = managedStatus;
            return this;
        }

        @Override
        public final Builder managedStatus(ManagedStatus managedStatus) {
            this.managedStatus(managedStatus == null ? null : managedStatus.toString());
            return this;
        }

        public final String getPlatformType() {
            return this.platformType;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType == null ? null : platformType.toString());
            return this;
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public InstanceInfo build() {
            return new InstanceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceInfo> {
        public Builder agentType(String var1);

        public Builder agentVersion(String var1);

        public Builder computerName(String var1);

        public Builder instanceStatus(String var1);

        public Builder ipAddress(String var1);

        public Builder managedStatus(String var1);

        public Builder managedStatus(ManagedStatus var1);

        public Builder platformType(String var1);

        public Builder platformType(PlatformType var1);

        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);
    }
}

