/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionInputs;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionInputs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionInputs> {
    private static final SdkField<AutomationExecutionInputs> AUTOMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Automation").getter(ExecutionInputs.getter(ExecutionInputs::automation)).setter(ExecutionInputs.setter(Builder::automation)).constructor(AutomationExecutionInputs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Automation", AUTOMATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AutomationExecutionInputs automation;
    private final Type type;

    private ExecutionInputs(BuilderImpl builder) {
        this.automation = builder.automation;
        this.type = builder.type;
    }

    public final AutomationExecutionInputs automation() {
        return this.automation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionInputs)) {
            return false;
        }
        ExecutionInputs other = (ExecutionInputs)obj;
        return Objects.equals(this.automation(), other.automation());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionInputs").add("Automation", (Object)this.automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Automation": {
                return Optional.ofNullable(clazz.cast(this.automation()));
            }
        }
        return Optional.empty();
    }

    public static ExecutionInputs fromAutomation(AutomationExecutionInputs automation) {
        return (ExecutionInputs)ExecutionInputs.builder().automation(automation).build();
    }

    public static ExecutionInputs fromAutomation(Consumer<AutomationExecutionInputs.Builder> automation) {
        AutomationExecutionInputs.Builder builder = AutomationExecutionInputs.builder();
        automation.accept(builder);
        return ExecutionInputs.fromAutomation((AutomationExecutionInputs)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionInputs, T> g) {
        return obj -> g.apply((ExecutionInputs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTOMATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AutomationExecutionInputs automation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionInputs model) {
            this.automation(model.automation);
        }

        public final AutomationExecutionInputs.Builder getAutomation() {
            return this.automation != null ? this.automation.toBuilder() : null;
        }

        public final void setAutomation(AutomationExecutionInputs.BuilderImpl automation) {
            AutomationExecutionInputs oldValue = this.automation;
            this.automation = automation != null ? automation.build() : null;
            this.handleUnionValueChange(Type.AUTOMATION, oldValue, this.automation);
        }

        @Override
        public final Builder automation(AutomationExecutionInputs automation) {
            AutomationExecutionInputs oldValue = this.automation;
            this.automation = automation;
            this.handleUnionValueChange(Type.AUTOMATION, oldValue, this.automation);
            return this;
        }

        public ExecutionInputs build() {
            return new ExecutionInputs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionInputs> {
        public Builder automation(AutomationExecutionInputs var1);

        default public Builder automation(Consumer<AutomationExecutionInputs.Builder> automation) {
            return this.automation((AutomationExecutionInputs)((AutomationExecutionInputs.Builder)AutomationExecutionInputs.builder().applyMutation(automation)).build());
        }
    }
}

