/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Activation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Activation> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationId").getter(Activation.getter(Activation::activationId)).setter(Activation.setter(Builder::activationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Activation.getter(Activation::description)).setter(Activation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultInstanceName").getter(Activation.getter(Activation::defaultInstanceName)).setter(Activation.setter(Builder::defaultInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceName").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRole").getter(Activation.getter(Activation::iamRole)).setter(Activation.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<Integer> REGISTRATION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegistrationLimit").getter(Activation.getter(Activation::registrationLimit)).setter(Activation.setter(Builder::registrationLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationLimit").build()}).build();
    private static final SdkField<Integer> REGISTRATIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegistrationsCount").getter(Activation.getter(Activation::registrationsCount)).setter(Activation.setter(Builder::registrationsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationsCount").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(Activation.getter(Activation::expirationDate)).setter(Activation.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final SdkField<Boolean> EXPIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Expired").getter(Activation.getter(Activation::expired)).setter(Activation.setter(Builder::expired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expired").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(Activation.getter(Activation::createdDate)).setter(Activation.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Activation.getter(Activation::tags)).setter(Activation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD, DESCRIPTION_FIELD, DEFAULT_INSTANCE_NAME_FIELD, IAM_ROLE_FIELD, REGISTRATION_LIMIT_FIELD, REGISTRATIONS_COUNT_FIELD, EXPIRATION_DATE_FIELD, EXPIRED_FIELD, CREATED_DATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActivationId", ACTIVATION_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DefaultInstanceName", DEFAULT_INSTANCE_NAME_FIELD);
            this.put("IamRole", IAM_ROLE_FIELD);
            this.put("RegistrationLimit", REGISTRATION_LIMIT_FIELD);
            this.put("RegistrationsCount", REGISTRATIONS_COUNT_FIELD);
            this.put("ExpirationDate", EXPIRATION_DATE_FIELD);
            this.put("Expired", EXPIRED_FIELD);
            this.put("CreatedDate", CREATED_DATE_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String activationId;
    private final String description;
    private final String defaultInstanceName;
    private final String iamRole;
    private final Integer registrationLimit;
    private final Integer registrationsCount;
    private final Instant expirationDate;
    private final Boolean expired;
    private final Instant createdDate;
    private final List<Tag> tags;

    private Activation(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.registrationsCount = builder.registrationsCount;
        this.expirationDate = builder.expirationDate;
        this.expired = builder.expired;
        this.createdDate = builder.createdDate;
        this.tags = builder.tags;
    }

    public final String activationId() {
        return this.activationId;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultInstanceName() {
        return this.defaultInstanceName;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final Integer registrationLimit() {
        return this.registrationLimit;
    }

    public final Integer registrationsCount() {
        return this.registrationsCount;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final Boolean expired() {
        return this.expired;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expired());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activation)) {
            return false;
        }
        Activation other = (Activation)obj;
        return Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultInstanceName(), other.defaultInstanceName()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationLimit(), other.registrationLimit()) && Objects.equals(this.registrationsCount(), other.registrationsCount()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.expired(), other.expired()) && Objects.equals(this.createdDate(), other.createdDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Activation").add("ActivationId", (Object)this.activationId()).add("Description", (Object)this.description()).add("DefaultInstanceName", (Object)this.defaultInstanceName()).add("IamRole", (Object)this.iamRole()).add("RegistrationLimit", (Object)this.registrationLimit()).add("RegistrationsCount", (Object)this.registrationsCount()).add("ExpirationDate", (Object)this.expirationDate()).add("Expired", (Object)this.expired()).add("CreatedDate", (Object)this.createdDate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationId": {
                return Optional.ofNullable(clazz.cast(this.activationId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultInstanceName": {
                return Optional.ofNullable(clazz.cast(this.defaultInstanceName()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "RegistrationLimit": {
                return Optional.ofNullable(clazz.cast(this.registrationLimit()));
            }
            case "RegistrationsCount": {
                return Optional.ofNullable(clazz.cast(this.registrationsCount()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Expired": {
                return Optional.ofNullable(clazz.cast(this.expired()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Activation, T> g) {
        return obj -> g.apply((Activation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activationId;
        private String description;
        private String defaultInstanceName;
        private String iamRole;
        private Integer registrationLimit;
        private Integer registrationsCount;
        private Instant expirationDate;
        private Boolean expired;
        private Instant createdDate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Activation model) {
            this.activationId(model.activationId);
            this.description(model.description);
            this.defaultInstanceName(model.defaultInstanceName);
            this.iamRole(model.iamRole);
            this.registrationLimit(model.registrationLimit);
            this.registrationsCount(model.registrationsCount);
            this.expirationDate(model.expirationDate);
            this.expired(model.expired);
            this.createdDate(model.createdDate);
            this.tags(model.tags);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultInstanceName() {
            return this.defaultInstanceName;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Integer getRegistrationLimit() {
            return this.registrationLimit;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final Integer getRegistrationsCount() {
            return this.registrationsCount;
        }

        public final void setRegistrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
        }

        @Override
        public final Builder registrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Boolean getExpired() {
            return this.expired;
        }

        public final void setExpired(Boolean expired) {
            this.expired = expired;
        }

        @Override
        public final Builder expired(Boolean expired) {
            this.expired = expired;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Activation build() {
            return new Activation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Activation> {
        public Builder activationId(String var1);

        public Builder description(String var1);

        public Builder defaultInstanceName(String var1);

        public Builder iamRole(String var1);

        public Builder registrationLimit(Integer var1);

        public Builder registrationsCount(Integer var1);

        public Builder expirationDate(Instant var1);

        public Builder expired(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

