/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancePropertiesRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeInstancePropertiesRequest.Builder, DescribeInstancePropertiesRequest> {
    private static final SdkField<List<InstancePropertyFilter>> INSTANCE_PROPERTY_FILTER_LIST_FIELD = SdkField
            .<List<InstancePropertyFilter>> builder(MarshallingType.LIST)
            .memberName("InstancePropertyFilterList")
            .getter(getter(DescribeInstancePropertiesRequest::instancePropertyFilterList))
            .setter(setter(Builder::instancePropertyFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePropertyFilterList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstancePropertyFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstancePropertyFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InstancePropertyStringFilter>> FILTERS_WITH_OPERATOR_FIELD = SdkField
            .<List<InstancePropertyStringFilter>> builder(MarshallingType.LIST)
            .memberName("FiltersWithOperator")
            .getter(getter(DescribeInstancePropertiesRequest::filtersWithOperator))
            .setter(setter(Builder::filtersWithOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiltersWithOperator").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstancePropertyStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstancePropertyStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeInstancePropertiesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstancePropertiesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_PROPERTY_FILTER_LIST_FIELD, FILTERS_WITH_OPERATOR_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<InstancePropertyFilter> instancePropertyFilterList;

    private final List<InstancePropertyStringFilter> filtersWithOperator;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstancePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.instancePropertyFilterList = builder.instancePropertyFilterList;
        this.filtersWithOperator = builder.filtersWithOperator;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstancePropertyFilterList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstancePropertyFilterList() {
        return instancePropertyFilterList != null && !(instancePropertyFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of instance property filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstancePropertyFilterList} method.
     * </p>
     * 
     * @return An array of instance property filters.
     */
    public final List<InstancePropertyFilter> instancePropertyFilterList() {
        return instancePropertyFilterList;
    }

    /**
     * For responses, this returns true if the service returned a value for the FiltersWithOperator property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFiltersWithOperator() {
        return filtersWithOperator != null && !(filtersWithOperator instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The request filters to use with the operator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiltersWithOperator} method.
     * </p>
     * 
     * @return The request filters to use with the operator.
     */
    public final List<InstancePropertyStringFilter> filtersWithOperator() {
        return filtersWithOperator;
    }

    /**
     * <p>
     * The maximum number of items to return for the call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for the call. The call also returns a token that you can specify in
     *         a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token provided by a previous request to use to return the next set of properties.
     * </p>
     * 
     * @return The token provided by a previous request to use to return the next set of properties.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstancePropertyFilterList() ? instancePropertyFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFiltersWithOperator() ? filtersWithOperator() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePropertiesRequest)) {
            return false;
        }
        DescribeInstancePropertiesRequest other = (DescribeInstancePropertiesRequest) obj;
        return hasInstancePropertyFilterList() == other.hasInstancePropertyFilterList()
                && Objects.equals(instancePropertyFilterList(), other.instancePropertyFilterList())
                && hasFiltersWithOperator() == other.hasFiltersWithOperator()
                && Objects.equals(filtersWithOperator(), other.filtersWithOperator())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancePropertiesRequest")
                .add("InstancePropertyFilterList", hasInstancePropertyFilterList() ? instancePropertyFilterList() : null)
                .add("FiltersWithOperator", hasFiltersWithOperator() ? filtersWithOperator() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancePropertyFilterList":
            return Optional.ofNullable(clazz.cast(instancePropertyFilterList()));
        case "FiltersWithOperator":
            return Optional.ofNullable(clazz.cast(filtersWithOperator()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePropertiesRequest, T> g) {
        return obj -> g.apply((DescribeInstancePropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancePropertiesRequest> {
        /**
         * <p>
         * An array of instance property filters.
         * </p>
         * 
         * @param instancePropertyFilterList
         *        An array of instance property filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePropertyFilterList(Collection<InstancePropertyFilter> instancePropertyFilterList);

        /**
         * <p>
         * An array of instance property filters.
         * </p>
         * 
         * @param instancePropertyFilterList
         *        An array of instance property filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePropertyFilterList(InstancePropertyFilter... instancePropertyFilterList);

        /**
         * <p>
         * An array of instance property filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.InstancePropertyFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssm.model.InstancePropertyFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.InstancePropertyFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #instancePropertyFilterList(List<InstancePropertyFilter>)}.
         * 
         * @param instancePropertyFilterList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.InstancePropertyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancePropertyFilterList(java.util.Collection<InstancePropertyFilter>)
         */
        Builder instancePropertyFilterList(Consumer<InstancePropertyFilter.Builder>... instancePropertyFilterList);

        /**
         * <p>
         * The request filters to use with the operator.
         * </p>
         * 
         * @param filtersWithOperator
         *        The request filters to use with the operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersWithOperator(Collection<InstancePropertyStringFilter> filtersWithOperator);

        /**
         * <p>
         * The request filters to use with the operator.
         * </p>
         * 
         * @param filtersWithOperator
         *        The request filters to use with the operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersWithOperator(InstancePropertyStringFilter... filtersWithOperator);

        /**
         * <p>
         * The request filters to use with the operator.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filtersWithOperator(List<InstancePropertyStringFilter>)}.
         * 
         * @param filtersWithOperator
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.InstancePropertyStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filtersWithOperator(java.util.Collection<InstancePropertyStringFilter>)
         */
        Builder filtersWithOperator(Consumer<InstancePropertyStringFilter.Builder>... filtersWithOperator);

        /**
         * <p>
         * The maximum number of items to return for the call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for the call. The call also returns a token that you can specify
         *        in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token provided by a previous request to use to return the next set of properties.
         * </p>
         * 
         * @param nextToken
         *        The token provided by a previous request to use to return the next set of properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<InstancePropertyFilter> instancePropertyFilterList = DefaultSdkAutoConstructList.getInstance();

        private List<InstancePropertyStringFilter> filtersWithOperator = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePropertiesRequest model) {
            super(model);
            instancePropertyFilterList(model.instancePropertyFilterList);
            filtersWithOperator(model.filtersWithOperator);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<InstancePropertyFilter.Builder> getInstancePropertyFilterList() {
            List<InstancePropertyFilter.Builder> result = InstancePropertyFilterListCopier
                    .copyToBuilder(this.instancePropertyFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstancePropertyFilterList(Collection<InstancePropertyFilter.BuilderImpl> instancePropertyFilterList) {
            this.instancePropertyFilterList = InstancePropertyFilterListCopier.copyFromBuilder(instancePropertyFilterList);
        }

        @Override
        public final Builder instancePropertyFilterList(Collection<InstancePropertyFilter> instancePropertyFilterList) {
            this.instancePropertyFilterList = InstancePropertyFilterListCopier.copy(instancePropertyFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePropertyFilterList(InstancePropertyFilter... instancePropertyFilterList) {
            instancePropertyFilterList(Arrays.asList(instancePropertyFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePropertyFilterList(Consumer<InstancePropertyFilter.Builder>... instancePropertyFilterList) {
            instancePropertyFilterList(Stream.of(instancePropertyFilterList)
                    .map(c -> InstancePropertyFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstancePropertyStringFilter.Builder> getFiltersWithOperator() {
            List<InstancePropertyStringFilter.Builder> result = InstancePropertyStringFilterListCopier
                    .copyToBuilder(this.filtersWithOperator);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiltersWithOperator(Collection<InstancePropertyStringFilter.BuilderImpl> filtersWithOperator) {
            this.filtersWithOperator = InstancePropertyStringFilterListCopier.copyFromBuilder(filtersWithOperator);
        }

        @Override
        public final Builder filtersWithOperator(Collection<InstancePropertyStringFilter> filtersWithOperator) {
            this.filtersWithOperator = InstancePropertyStringFilterListCopier.copy(filtersWithOperator);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersWithOperator(InstancePropertyStringFilter... filtersWithOperator) {
            filtersWithOperator(Arrays.asList(filtersWithOperator));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filtersWithOperator(Consumer<InstancePropertyStringFilter.Builder>... filtersWithOperator) {
            filtersWithOperator(Stream.of(filtersWithOperator)
                    .map(c -> InstancePropertyStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancePropertiesRequest build() {
            return new DescribeInstancePropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
