/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask;

public class DescribeMaintenanceWindowTasksIterable
implements SdkIterable<DescribeMaintenanceWindowTasksResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowTasksIterable(SsmClient client, DescribeMaintenanceWindowTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMaintenanceWindowTasksResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowTask> tasks() {
        Function<DescribeMaintenanceWindowTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowTasksResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowTasksResponse> {
        private DescribeMaintenanceWindowTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowTasksResponse nextPage(DescribeMaintenanceWindowTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowTasksIterable.this.client.describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowTasksIterable.this.client.describeMaintenanceWindowTasks((DescribeMaintenanceWindowTasksRequest)((Object)DescribeMaintenanceWindowTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

