/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget;

public class DescribeMaintenanceWindowsForTargetIterable
implements SdkIterable<DescribeMaintenanceWindowsForTargetResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowsForTargetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowsForTargetIterable(SsmClient client, DescribeMaintenanceWindowsForTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMaintenanceWindowsForTargetResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowsForTargetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowIdentityForTarget> windowIdentities() {
        Function<DescribeMaintenanceWindowsForTargetResponse, Iterator> getIterator = response -> {
            if (response != null && response.windowIdentities() != null) {
                return response.windowIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowsForTargetResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowsForTargetResponse> {
        private DescribeMaintenanceWindowsForTargetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowsForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowsForTargetResponse nextPage(DescribeMaintenanceWindowsForTargetResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowsForTargetIterable.this.client.describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowsForTargetIterable.this.client.describeMaintenanceWindowsForTarget((DescribeMaintenanceWindowsForTargetRequest)((Object)DescribeMaintenanceWindowsForTargetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

