/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity;

public class DescribeMaintenanceWindowExecutionTasksIterable
implements SdkIterable<DescribeMaintenanceWindowExecutionTasksResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowExecutionTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowExecutionTasksIterable(SsmClient client, DescribeMaintenanceWindowExecutionTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMaintenanceWindowExecutionTasksResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowExecutionTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        Function<DescribeMaintenanceWindowExecutionTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.windowExecutionTaskIdentities() != null) {
                return response.windowExecutionTaskIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowExecutionTasksResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowExecutionTasksResponse> {
        private DescribeMaintenanceWindowExecutionTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowExecutionTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowExecutionTasksResponse nextPage(DescribeMaintenanceWindowExecutionTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowExecutionTasksIterable.this.client.describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowExecutionTasksIterable.this.client.describeMaintenanceWindowExecutionTasks((DescribeMaintenanceWindowExecutionTasksRequest)((Object)DescribeMaintenanceWindowExecutionTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

