/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateOpsItemRelatedItemRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, AssociateOpsItemRelatedItemRequest> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(AssociateOpsItemRelatedItemRequest.getter(AssociateOpsItemRelatedItemRequest::opsItemId)).setter(AssociateOpsItemRelatedItemRequest.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationType").getter(AssociateOpsItemRelatedItemRequest.getter(AssociateOpsItemRelatedItemRequest::associationType)).setter(AssociateOpsItemRelatedItemRequest.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(AssociateOpsItemRelatedItemRequest.getter(AssociateOpsItemRelatedItemRequest::resourceType)).setter(AssociateOpsItemRelatedItemRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceUri").getter(AssociateOpsItemRelatedItemRequest.getter(AssociateOpsItemRelatedItemRequest::resourceUri)).setter(AssociateOpsItemRelatedItemRequest.setter(Builder::resourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD, ASSOCIATION_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_URI_FIELD));
    private final String opsItemId;
    private final String associationType;
    private final String resourceType;
    private final String resourceUri;

    private AssociateOpsItemRelatedItemRequest(BuilderImpl builder) {
        super(builder);
        this.opsItemId = builder.opsItemId;
        this.associationType = builder.associationType;
        this.resourceType = builder.resourceType;
        this.resourceUri = builder.resourceUri;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String associationType() {
        return this.associationType;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceUri() {
        return this.resourceUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateOpsItemRelatedItemRequest)) {
            return false;
        }
        AssociateOpsItemRelatedItemRequest other = (AssociateOpsItemRelatedItemRequest)((Object)obj);
        return Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.associationType(), other.associationType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceUri(), other.resourceUri());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateOpsItemRelatedItemRequest").add("OpsItemId", (Object)this.opsItemId()).add("AssociationType", (Object)this.associationType()).add("ResourceType", (Object)this.resourceType()).add("ResourceUri", (Object)this.resourceUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "AssociationType": {
                return Optional.ofNullable(clazz.cast(this.associationType()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceUri": {
                return Optional.ofNullable(clazz.cast(this.resourceUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateOpsItemRelatedItemRequest, T> g) {
        return obj -> g.apply((AssociateOpsItemRelatedItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String opsItemId;
        private String associationType;
        private String resourceType;
        private String resourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateOpsItemRelatedItemRequest model) {
            super(model);
            this.opsItemId(model.opsItemId);
            this.associationType(model.associationType);
            this.resourceType(model.resourceType);
            this.resourceUri(model.resourceUri);
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceUri() {
            return this.resourceUri;
        }

        public final void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        @Override
        public final Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateOpsItemRelatedItemRequest build() {
            return new AssociateOpsItemRelatedItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateOpsItemRelatedItemRequest> {
        public Builder opsItemId(String var1);

        public Builder associationType(String var1);

        public Builder resourceType(String var1);

        public Builder resourceUri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

