/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchSourceProductListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PatchSource.getter(PatchSource::name)).setter(PatchSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Products").getter(PatchSource.getter(PatchSource::products)).setter(PatchSource.setter(Builder::products)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Products").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(PatchSource.getter(PatchSource::configuration)).setter(PatchSource.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PRODUCTS_FIELD, CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> products;
    private final String configuration;

    private PatchSource(BuilderImpl builder) {
        this.name = builder.name;
        this.products = builder.products;
        this.configuration = builder.configuration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasProducts() {
        return this.products != null && !(this.products instanceof SdkAutoConstructList);
    }

    public final List<String> products() {
        return this.products;
    }

    public final String configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProducts() ? this.products() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchSource)) {
            return false;
        }
        PatchSource other = (PatchSource)obj;
        return Objects.equals(this.name(), other.name()) && this.hasProducts() == other.hasProducts() && Objects.equals(this.products(), other.products()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"PatchSource").add("Name", (Object)this.name()).add("Products", this.hasProducts() ? this.products() : null).add("Configuration", (Object)(this.configuration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Products": {
                return Optional.ofNullable(clazz.cast(this.products()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchSource, T> g) {
        return obj -> g.apply((PatchSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> products = DefaultSdkAutoConstructList.getInstance();
        private String configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchSource model) {
            this.name(model.name);
            this.products(model.products);
            this.configuration(model.configuration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getProducts() {
            if (this.products instanceof SdkAutoConstructList) {
                return null;
            }
            return this.products;
        }

        public final void setProducts(Collection<String> products) {
            this.products = PatchSourceProductListCopier.copy(products);
        }

        @Override
        public final Builder products(Collection<String> products) {
            this.products = PatchSourceProductListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(String ... products) {
            this.products(Arrays.asList(products));
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public PatchSource build() {
            return new PatchSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchSource> {
        public Builder name(String var1);

        public Builder products(Collection<String> var1);

        public Builder products(String ... var1);

        public Builder configuration(String var1);
    }
}

