/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowExecutionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
    private static final SdkField<List<MaintenanceWindowExecution>> WINDOW_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WindowExecutions").getter(DescribeMaintenanceWindowExecutionsResponse.getter(DescribeMaintenanceWindowExecutionsResponse::windowExecutions)).setter(DescribeMaintenanceWindowExecutionsResponse.setter(Builder::windowExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowExecutionsResponse.getter(DescribeMaintenanceWindowExecutionsResponse::nextToken)).setter(DescribeMaintenanceWindowExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MaintenanceWindowExecution> windowExecutions;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutions = builder.windowExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWindowExecutions() {
        return this.windowExecutions != null && !(this.windowExecutions instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindowExecution> windowExecutions() {
        return this.windowExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWindowExecutions() ? this.windowExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionsResponse other = (DescribeMaintenanceWindowExecutionsResponse)((Object)obj);
        return this.hasWindowExecutions() == other.hasWindowExecutions() && Objects.equals(this.windowExecutions(), other.windowExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowExecutionsResponse").add("WindowExecutions", this.hasWindowExecutions() ? this.windowExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutions": {
                return Optional.ofNullable(clazz.cast(this.windowExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecution> windowExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionsResponse model) {
            super(model);
            this.windowExecutions(model.windowExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowExecution.Builder> getWindowExecutions() {
            List<MaintenanceWindowExecution.Builder> result = MaintenanceWindowExecutionListCopier.copyToBuilder(this.windowExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWindowExecutions(Collection<MaintenanceWindowExecution.BuilderImpl> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copyFromBuilder(windowExecutions);
        }

        @Override
        public final Builder windowExecutions(Collection<MaintenanceWindowExecution> windowExecutions) {
            this.windowExecutions = MaintenanceWindowExecutionListCopier.copy(windowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(MaintenanceWindowExecution ... windowExecutions) {
            this.windowExecutions(Arrays.asList(windowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder> ... windowExecutions) {
            this.windowExecutions(Stream.of(windowExecutions).map(c -> (MaintenanceWindowExecution)((MaintenanceWindowExecution.Builder)MaintenanceWindowExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionsResponse build() {
            return new DescribeMaintenanceWindowExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsResponse> {
        public Builder windowExecutions(Collection<MaintenanceWindowExecution> var1);

        public Builder windowExecutions(MaintenanceWindowExecution ... var1);

        public Builder windowExecutions(Consumer<MaintenanceWindowExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

