/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.ScheduledWindowExecution;

public class DescribeMaintenanceWindowScheduleIterable
implements SdkIterable<DescribeMaintenanceWindowScheduleResponse> {
    private final SsmClient client;
    private final DescribeMaintenanceWindowScheduleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMaintenanceWindowScheduleIterable(SsmClient client, DescribeMaintenanceWindowScheduleRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMaintenanceWindowScheduleResponseFetcher();
    }

    public Iterator<DescribeMaintenanceWindowScheduleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledWindowExecution> scheduledWindowExecutions() {
        Function<DescribeMaintenanceWindowScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledWindowExecutions() != null) {
                return response.scheduledWindowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMaintenanceWindowScheduleResponseFetcher
    implements SyncPageFetcher<DescribeMaintenanceWindowScheduleResponse> {
        private DescribeMaintenanceWindowScheduleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMaintenanceWindowScheduleResponse nextPage(DescribeMaintenanceWindowScheduleResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowScheduleIterable.this.client.describeMaintenanceWindowSchedule(DescribeMaintenanceWindowScheduleIterable.this.firstRequest);
            }
            return DescribeMaintenanceWindowScheduleIterable.this.client.describeMaintenanceWindowSchedule((DescribeMaintenanceWindowScheduleRequest)((Object)DescribeMaintenanceWindowScheduleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

