/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy;
import software.amazon.awssdk.services.ssm.model.ParameterLabelListCopier;
import software.amazon.awssdk.services.ssm.model.ParameterPolicyListCopier;
import software.amazon.awssdk.services.ssm.model.ParameterTier;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterHistory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterHistory> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ParameterHistory.getter(ParameterHistory::name)).setter(ParameterHistory.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ParameterHistory.getter(ParameterHistory::typeAsString)).setter(ParameterHistory.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(ParameterHistory.getter(ParameterHistory::keyId)).setter(ParameterHistory.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(ParameterHistory.getter(ParameterHistory::lastModifiedDate)).setter(ParameterHistory.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedUser").getter(ParameterHistory.getter(ParameterHistory::lastModifiedUser)).setter(ParameterHistory.setter(Builder::lastModifiedUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedUser").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ParameterHistory.getter(ParameterHistory::description)).setter(ParameterHistory.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ParameterHistory.getter(ParameterHistory::value)).setter(ParameterHistory.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedPattern").getter(ParameterHistory.getter(ParameterHistory::allowedPattern)).setter(ParameterHistory.setter(Builder::allowedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPattern").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(ParameterHistory.getter(ParameterHistory::version)).setter(ParameterHistory.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ParameterHistory.getter(ParameterHistory::labels)).setter(ParameterHistory.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(ParameterHistory.getter(ParameterHistory::tierAsString)).setter(ParameterHistory.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<List<ParameterInlinePolicy>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(ParameterHistory.getter(ParameterHistory::policies)).setter(ParameterHistory.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterInlinePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(ParameterHistory.getter(ParameterHistory::dataType)).setter(ParameterHistory.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, KEY_ID_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_USER_FIELD, DESCRIPTION_FIELD, VALUE_FIELD, ALLOWED_PATTERN_FIELD, VERSION_FIELD, LABELS_FIELD, TIER_FIELD, POLICIES_FIELD, DATA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String keyId;
    private final Instant lastModifiedDate;
    private final String lastModifiedUser;
    private final String description;
    private final String value;
    private final String allowedPattern;
    private final Long version;
    private final List<String> labels;
    private final String tier;
    private final List<ParameterInlinePolicy> policies;
    private final String dataType;

    private ParameterHistory(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.description = builder.description;
        this.value = builder.value;
        this.allowedPattern = builder.allowedPattern;
        this.version = builder.version;
        this.labels = builder.labels;
        this.tier = builder.tier;
        this.policies = builder.policies;
        this.dataType = builder.dataType;
    }

    public final String name() {
        return this.name;
    }

    public final ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public final String description() {
        return this.description;
    }

    public final String value() {
        return this.value;
    }

    public final String allowedPattern() {
        return this.allowedPattern;
    }

    public final Long version() {
        return this.version;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final ParameterTier tier() {
        return ParameterTier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<ParameterInlinePolicy> policies() {
        return this.policies;
    }

    public final String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterHistory)) {
            return false;
        }
        ParameterHistory other = (ParameterHistory)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.allowedPattern(), other.allowedPattern()) && Objects.equals(this.version(), other.version()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.tierAsString(), other.tierAsString()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.dataType(), other.dataType());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterHistory").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("KeyId", (Object)this.keyId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("Description", (Object)this.description()).add("Value", (Object)this.value()).add("AllowedPattern", (Object)this.allowedPattern()).add("Version", (Object)this.version()).add("Labels", this.hasLabels() ? this.labels() : null).add("Tier", (Object)this.tierAsString()).add("Policies", this.hasPolicies() ? this.policies() : null).add("DataType", (Object)this.dataType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedUser": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedUser()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterHistory, T> g) {
        return obj -> g.apply((ParameterHistory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String keyId;
        private Instant lastModifiedDate;
        private String lastModifiedUser;
        private String description;
        private String value;
        private String allowedPattern;
        private Long version;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String tier;
        private List<ParameterInlinePolicy> policies = DefaultSdkAutoConstructList.getInstance();
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterHistory model) {
            this.name(model.name);
            this.type(model.type);
            this.keyId(model.keyId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.description(model.description);
            this.value(model.value);
            this.allowedPattern(model.allowedPattern);
            this.version(model.version);
            this.labels(model.labels);
            this.tier(model.tier);
            this.policies(model.policies);
            this.dataType(model.dataType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        @Transient
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        @Override
        @Transient
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        @Transient
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ParameterLabelListCopier.copy(labels);
        }

        @Override
        @Transient
        public final Builder labels(Collection<String> labels) {
            this.labels = ParameterLabelListCopier.copy(labels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        @Transient
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        @Transient
        public final Builder tier(ParameterTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final List<ParameterInlinePolicy.Builder> getPolicies() {
            List<ParameterInlinePolicy.Builder> result = ParameterPolicyListCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<ParameterInlinePolicy.BuilderImpl> policies) {
            this.policies = ParameterPolicyListCopier.copyFromBuilder(policies);
        }

        @Override
        @Transient
        public final Builder policies(Collection<ParameterInlinePolicy> policies) {
            this.policies = ParameterPolicyListCopier.copy(policies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policies(ParameterInlinePolicy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policies(Consumer<ParameterInlinePolicy.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (ParameterInlinePolicy)((ParameterInlinePolicy.Builder)ParameterInlinePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        @Transient
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public ParameterHistory build() {
            return new ParameterHistory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterHistory> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder description(String var1);

        public Builder value(String var1);

        public Builder allowedPattern(String var1);

        public Builder version(Long var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder tier(String var1);

        public Builder tier(ParameterTier var1);

        public Builder policies(Collection<ParameterInlinePolicy> var1);

        public Builder policies(ParameterInlinePolicy ... var1);

        public Builder policies(Consumer<ParameterInlinePolicy.Builder> ... var1);

        public Builder dataType(String var1);
    }
}

