/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceTypeForTagging {
    DOCUMENT("Document"),
    MANAGED_INSTANCE("ManagedInstance"),
    MAINTENANCE_WINDOW("MaintenanceWindow"),
    PARAMETER("Parameter"),
    PATCH_BASELINE("PatchBaseline"),
    OPS_ITEM("OpsItem"),
    OPS_METADATA("OpsMetadata"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceTypeForTagging(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeForTagging fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceTypeForTagging.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeForTagging> knownValues() {
        return Stream.of(ResourceTypeForTagging.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

