/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceComplianceSummariesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
    private static final SdkField<List<ResourceComplianceSummaryItem>> RESOURCE_COMPLIANCE_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceComplianceSummaryItems").getter(ListResourceComplianceSummariesResponse.getter(ListResourceComplianceSummariesResponse::resourceComplianceSummaryItems)).setter(ListResourceComplianceSummariesResponse.setter(Builder::resourceComplianceSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceComplianceSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceComplianceSummaryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourceComplianceSummariesResponse.getter(ListResourceComplianceSummariesResponse::nextToken)).setter(ListResourceComplianceSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COMPLIANCE_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;
    private final String nextToken;

    private ListResourceComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceComplianceSummaryItems = builder.resourceComplianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceComplianceSummaryItems() {
        return this.resourceComplianceSummaryItems != null && !(this.resourceComplianceSummaryItems instanceof SdkAutoConstructList);
    }

    public final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        return this.resourceComplianceSummaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceComplianceSummaryItems() ? this.resourceComplianceSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceComplianceSummariesResponse)) {
            return false;
        }
        ListResourceComplianceSummariesResponse other = (ListResourceComplianceSummariesResponse)((Object)obj);
        return this.hasResourceComplianceSummaryItems() == other.hasResourceComplianceSummaryItems() && Objects.equals(this.resourceComplianceSummaryItems(), other.resourceComplianceSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceComplianceSummariesResponse").add("ResourceComplianceSummaryItems", this.hasResourceComplianceSummaryItems() ? this.resourceComplianceSummaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceComplianceSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.resourceComplianceSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceComplianceSummariesResponse, T> g) {
        return obj -> g.apply((ListResourceComplianceSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceComplianceSummariesResponse model) {
            super(model);
            this.resourceComplianceSummaryItems(model.resourceComplianceSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceComplianceSummaryItem.Builder> getResourceComplianceSummaryItems() {
            if (this.resourceComplianceSummaryItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceComplianceSummaryItems != null ? (Collection)this.resourceComplianceSummaryItems.stream().map(ResourceComplianceSummaryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copy(resourceComplianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem ... resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems(Arrays.asList(resourceComplianceSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(Consumer<ResourceComplianceSummaryItem.Builder> ... resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems(Stream.of(resourceComplianceSummaryItems).map(c -> (ResourceComplianceSummaryItem)((ResourceComplianceSummaryItem.Builder)ResourceComplianceSummaryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem.BuilderImpl> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copyFromBuilder(resourceComplianceSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceComplianceSummariesResponse build() {
            return new ListResourceComplianceSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
        public Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> var1);

        public Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem ... var1);

        public Builder resourceComplianceSummaryItems(Consumer<ResourceComplianceSummaryItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

