/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsMetadata;
import software.amazon.awssdk.services.ssm.model.OpsMetadataListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpsMetadataResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListOpsMetadataResponse> {
    private static final SdkField<List<OpsMetadata>> OPS_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpsMetadataList").getter(ListOpsMetadataResponse.getter(ListOpsMetadataResponse::opsMetadataList)).setter(ListOpsMetadataResponse.setter(Builder::opsMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOpsMetadataResponse.getter(ListOpsMetadataResponse::nextToken)).setter(ListOpsMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<OpsMetadata> opsMetadataList;
    private final String nextToken;

    private ListOpsMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.opsMetadataList = builder.opsMetadataList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOpsMetadataList() {
        return this.opsMetadataList != null && !(this.opsMetadataList instanceof SdkAutoConstructList);
    }

    public final List<OpsMetadata> opsMetadataList() {
        return this.opsMetadataList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpsMetadataList() ? this.opsMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpsMetadataResponse)) {
            return false;
        }
        ListOpsMetadataResponse other = (ListOpsMetadataResponse)((Object)obj);
        return this.hasOpsMetadataList() == other.hasOpsMetadataList() && Objects.equals(this.opsMetadataList(), other.opsMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpsMetadataResponse").add("OpsMetadataList", this.hasOpsMetadataList() ? this.opsMetadataList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsMetadataList": {
                return Optional.ofNullable(clazz.cast(this.opsMetadataList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOpsMetadataResponse, T> g) {
        return obj -> g.apply((ListOpsMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<OpsMetadata> opsMetadataList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpsMetadataResponse model) {
            super(model);
            this.opsMetadataList(model.opsMetadataList);
            this.nextToken(model.nextToken);
        }

        public final Collection<OpsMetadata.Builder> getOpsMetadataList() {
            if (this.opsMetadataList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.opsMetadataList != null ? (Collection)this.opsMetadataList.stream().map(OpsMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder opsMetadataList(Collection<OpsMetadata> opsMetadataList) {
            this.opsMetadataList = OpsMetadataListCopier.copy(opsMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsMetadataList(OpsMetadata ... opsMetadataList) {
            this.opsMetadataList(Arrays.asList(opsMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsMetadataList(Consumer<OpsMetadata.Builder> ... opsMetadataList) {
            this.opsMetadataList(Stream.of(opsMetadataList).map(c -> (OpsMetadata)((OpsMetadata.Builder)OpsMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOpsMetadataList(Collection<OpsMetadata.BuilderImpl> opsMetadataList) {
            this.opsMetadataList = OpsMetadataListCopier.copyFromBuilder(opsMetadataList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOpsMetadataResponse build() {
            return new ListOpsMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpsMetadataResponse> {
        public Builder opsMetadataList(Collection<OpsMetadata> var1);

        public Builder opsMetadataList(OpsMetadata ... var1);

        public Builder opsMetadataList(Consumer<OpsMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

