/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AccountsCopier;
import software.amazon.awssdk.services.ssm.model.RegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetLocation> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(TargetLocation.getter(TargetLocation::accounts)).setter(TargetLocation.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(TargetLocation.getter(TargetLocation::regions)).setter(TargetLocation.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_LOCATION_MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLocationMaxConcurrency").getter(TargetLocation.getter(TargetLocation::targetLocationMaxConcurrency)).setter(TargetLocation.setter(Builder::targetLocationMaxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxConcurrency").build()}).build();
    private static final SdkField<String> TARGET_LOCATION_MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLocationMaxErrors").getter(TargetLocation.getter(TargetLocation::targetLocationMaxErrors)).setter(TargetLocation.setter(Builder::targetLocationMaxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxErrors").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleName").getter(TargetLocation.getter(TargetLocation::executionRoleName)).setter(TargetLocation.setter(Builder::executionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, REGIONS_FIELD, TARGET_LOCATION_MAX_CONCURRENCY_FIELD, TARGET_LOCATION_MAX_ERRORS_FIELD, EXECUTION_ROLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accounts;
    private final List<String> regions;
    private final String targetLocationMaxConcurrency;
    private final String targetLocationMaxErrors;
    private final String executionRoleName;

    private TargetLocation(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.targetLocationMaxConcurrency = builder.targetLocationMaxConcurrency;
        this.targetLocationMaxErrors = builder.targetLocationMaxErrors;
        this.executionRoleName = builder.executionRoleName;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<String> accounts() {
        return this.accounts;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final String targetLocationMaxConcurrency() {
        return this.targetLocationMaxConcurrency;
    }

    public final String targetLocationMaxErrors() {
        return this.targetLocationMaxErrors;
    }

    public final String executionRoleName() {
        return this.executionRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocationMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocationMaxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetLocation)) {
            return false;
        }
        TargetLocation other = (TargetLocation)obj;
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.targetLocationMaxConcurrency(), other.targetLocationMaxConcurrency()) && Objects.equals(this.targetLocationMaxErrors(), other.targetLocationMaxErrors()) && Objects.equals(this.executionRoleName(), other.executionRoleName());
    }

    public final String toString() {
        return ToString.builder((String)"TargetLocation").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("Regions", this.hasRegions() ? this.regions() : null).add("TargetLocationMaxConcurrency", (Object)this.targetLocationMaxConcurrency()).add("TargetLocationMaxErrors", (Object)this.targetLocationMaxErrors()).add("ExecutionRoleName", (Object)this.executionRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "TargetLocationMaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.targetLocationMaxConcurrency()));
            }
            case "TargetLocationMaxErrors": {
                return Optional.ofNullable(clazz.cast(this.targetLocationMaxErrors()));
            }
            case "ExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.executionRoleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetLocation, T> g) {
        return obj -> g.apply((TargetLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String targetLocationMaxConcurrency;
        private String targetLocationMaxErrors;
        private String executionRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetLocation model) {
            this.accounts(model.accounts);
            this.regions(model.regions);
            this.targetLocationMaxConcurrency(model.targetLocationMaxConcurrency);
            this.targetLocationMaxErrors(model.targetLocationMaxErrors);
            this.executionRoleName(model.executionRoleName);
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        public final String getTargetLocationMaxConcurrency() {
            return this.targetLocationMaxConcurrency;
        }

        @Override
        public final Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
            return this;
        }

        public final void setTargetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
        }

        public final String getTargetLocationMaxErrors() {
            return this.targetLocationMaxErrors;
        }

        @Override
        public final Builder targetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
            return this;
        }

        public final void setTargetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
        }

        public final String getExecutionRoleName() {
            return this.executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        public TargetLocation build() {
            return new TargetLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetLocation> {
        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder targetLocationMaxConcurrency(String var1);

        public Builder targetLocationMaxErrors(String var1);

        public Builder executionRoleName(String var1);
    }
}

