/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl;
import software.amazon.awssdk.services.ssm.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(Session.getter(Session::sessionId)).setter(Session.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(Session.getter(Session::target)).setter(Session.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Session.getter(Session::statusAsString)).setter(Session.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(Session.getter(Session::startDate)).setter(Session.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(Session.getter(Session::endDate)).setter(Session.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(Session.getter(Session::documentName)).setter(Session.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(Session.getter(Session::owner)).setter(Session.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Details").getter(Session.getter(Session::details)).setter(Session.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<SessionManagerOutputUrl> OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputUrl").getter(Session.getter(Session::outputUrl)).setter(Session.setter(Builder::outputUrl)).constructor(SessionManagerOutputUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, TARGET_FIELD, STATUS_FIELD, START_DATE_FIELD, END_DATE_FIELD, DOCUMENT_NAME_FIELD, OWNER_FIELD, DETAILS_FIELD, OUTPUT_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private final String target;
    private final String status;
    private final Instant startDate;
    private final Instant endDate;
    private final String documentName;
    private final String owner;
    private final String details;
    private final SessionManagerOutputUrl outputUrl;

    private Session(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.target = builder.target;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.documentName = builder.documentName;
        this.owner = builder.owner;
        this.details = builder.details;
        this.outputUrl = builder.outputUrl;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String target() {
        return this.target;
    }

    public final SessionStatus status() {
        return SessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String owner() {
        return this.owner;
    }

    public final String details() {
        return this.details;
    }

    public final SessionManagerOutputUrl outputUrl() {
        return this.outputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.outputUrl(), other.outputUrl());
    }

    public final String toString() {
        return ToString.builder((String)"Session").add("SessionId", (Object)this.sessionId()).add("Target", (Object)this.target()).add("Status", (Object)this.statusAsString()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("DocumentName", (Object)this.documentName()).add("Owner", (Object)this.owner()).add("Details", (Object)this.details()).add("OutputUrl", (Object)this.outputUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "OutputUrl": {
                return Optional.ofNullable(clazz.cast(this.outputUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionId;
        private String target;
        private String status;
        private Instant startDate;
        private Instant endDate;
        private String documentName;
        private String owner;
        private String details;
        private SessionManagerOutputUrl outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.sessionId(model.sessionId);
            this.target(model.target);
            this.status(model.status);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.documentName(model.documentName);
            this.owner(model.owner);
            this.details(model.details);
            this.outputUrl(model.outputUrl);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final SessionManagerOutputUrl.Builder getOutputUrl() {
            return this.outputUrl != null ? this.outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(SessionManagerOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(SessionManagerOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder sessionId(String var1);

        public Builder target(String var1);

        public Builder status(String var1);

        public Builder status(SessionStatus var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder documentName(String var1);

        public Builder owner(String var1);

        public Builder details(String var1);

        public Builder outputUrl(SessionManagerOutputUrl var1);

        default public Builder outputUrl(Consumer<SessionManagerOutputUrl.Builder> outputUrl) {
            return this.outputUrl((SessionManagerOutputUrl)((SessionManagerOutputUrl.Builder)SessionManagerOutputUrl.builder().applyMutation(outputUrl)).build());
        }
    }
}

