/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentMetadataHistoryResponse extends SsmResponse implements
        ToCopyableBuilder<ListDocumentMetadataHistoryResponse.Builder, ListDocumentMetadataHistoryResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListDocumentMetadataHistoryResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(ListDocumentMetadataHistoryResponse::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Author")
            .getter(getter(ListDocumentMetadataHistoryResponse::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Author").build()).build();

    private static final SdkField<DocumentMetadataResponseInfo> METADATA_FIELD = SdkField
            .<DocumentMetadataResponseInfo> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(ListDocumentMetadataHistoryResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(DocumentMetadataResponseInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDocumentMetadataHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DOCUMENT_VERSION_FIELD, AUTHOR_FIELD, METADATA_FIELD, NEXT_TOKEN_FIELD));

    private final String name;

    private final String documentVersion;

    private final String author;

    private final DocumentMetadataResponseInfo metadata;

    private final String nextToken;

    private ListDocumentMetadataHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.author = builder.author;
        this.metadata = builder.metadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the document.
     * </p>
     * 
     * @return The version of the document.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The user ID of the person in the organization who requested the document review.
     * </p>
     * 
     * @return The user ID of the person in the organization who requested the document review.
     */
    public final String author() {
        return author;
    }

    /**
     * <p>
     * Information about the response to the document approval request.
     * </p>
     * 
     * @return Information about the response to the document approval request.
     */
    public final DocumentMetadataResponseInfo metadata() {
        return metadata;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentMetadataHistoryResponse)) {
            return false;
        }
        ListDocumentMetadataHistoryResponse other = (ListDocumentMetadataHistoryResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(author(), other.author()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDocumentMetadataHistoryResponse").add("Name", name())
                .add("DocumentVersion", documentVersion()).add("Author", author()).add("Metadata", metadata())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Author":
            return Optional.ofNullable(clazz.cast(author()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentMetadataHistoryResponse, T> g) {
        return obj -> g.apply((ListDocumentMetadataHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDocumentMetadataHistoryResponse> {
        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the document.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The user ID of the person in the organization who requested the document review.
         * </p>
         * 
         * @param author
         *        The user ID of the person in the organization who requested the document review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * Information about the response to the document approval request.
         * </p>
         * 
         * @param metadata
         *        Information about the response to the document approval request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(DocumentMetadataResponseInfo metadata);

        /**
         * <p>
         * Information about the response to the document approval request.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentMetadataResponseInfo.Builder} avoiding
         * the need to create one manually via {@link DocumentMetadataResponseInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentMetadataResponseInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(DocumentMetadataResponseInfo)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link DocumentMetadataResponseInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(DocumentMetadataResponseInfo)
         */
        default Builder metadata(Consumer<DocumentMetadataResponseInfo.Builder> metadata) {
            return metadata(DocumentMetadataResponseInfo.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String name;

        private String documentVersion;

        private String author;

        private DocumentMetadataResponseInfo metadata;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentMetadataHistoryResponse model) {
            super(model);
            name(model.name);
            documentVersion(model.documentVersion);
            author(model.author);
            metadata(model.metadata);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAuthor() {
            return author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final DocumentMetadataResponseInfo.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadataResponseInfo metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(DocumentMetadataResponseInfo.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentMetadataHistoryResponse build() {
            return new ListDocumentMetadataHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
