/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPatchBaselineResponse extends SsmResponse implements
        ToCopyableBuilder<GetPatchBaselineResponse.Builder, GetPatchBaselineResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaselineId").getter(getter(GetPatchBaselineResponse::baselineId)).setter(setter(Builder::baselineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetPatchBaselineResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(GetPatchBaselineResponse::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField
            .<PatchFilterGroup> builder(MarshallingType.SDK_POJO).memberName("GlobalFilters")
            .getter(getter(GetPatchBaselineResponse::globalFilters)).setter(setter(Builder::globalFilters))
            .constructor(PatchFilterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()).build();

    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField
            .<PatchRuleGroup> builder(MarshallingType.SDK_POJO).memberName("ApprovalRules")
            .getter(getter(GetPatchBaselineResponse::approvalRules)).setter(setter(Builder::approvalRules))
            .constructor(PatchRuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()).build();

    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApprovedPatches")
            .getter(getter(GetPatchBaselineResponse::approvedPatches))
            .setter(setter(Builder::approvedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApprovedPatchesComplianceLevel")
            .getter(getter(GetPatchBaselineResponse::approvedPatchesComplianceLevelAsString))
            .setter(setter(Builder::approvedPatchesComplianceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel")
                    .build()).build();

    private static final SdkField<Boolean> APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApprovedPatchesEnableNonSecurity")
            .getter(getter(GetPatchBaselineResponse::approvedPatchesEnableNonSecurity))
            .setter(setter(Builder::approvedPatchesEnableNonSecurity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesEnableNonSecurity")
                    .build()).build();

    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RejectedPatches")
            .getter(getter(GetPatchBaselineResponse::rejectedPatches))
            .setter(setter(Builder::rejectedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REJECTED_PATCHES_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RejectedPatchesAction").getter(getter(GetPatchBaselineResponse::rejectedPatchesActionAsString))
            .setter(setter(Builder::rejectedPatchesAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatchesAction").build())
            .build();

    private static final SdkField<List<String>> PATCH_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PatchGroups")
            .getter(getter(GetPatchBaselineResponse::patchGroups))
            .setter(setter(Builder::patchGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(GetPatchBaselineResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Instant> MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedDate").getter(getter(GetPatchBaselineResponse::modifiedDate))
            .setter(setter(Builder::modifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetPatchBaselineResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<PatchSource>> SOURCES_FIELD = SdkField
            .<List<PatchSource>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(GetPatchBaselineResponse::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, NAME_FIELD,
            OPERATING_SYSTEM_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD,
            APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD, REJECTED_PATCHES_FIELD,
            REJECTED_PATCHES_ACTION_FIELD, PATCH_GROUPS_FIELD, CREATED_DATE_FIELD, MODIFIED_DATE_FIELD, DESCRIPTION_FIELD,
            SOURCES_FIELD));

    private final String baselineId;

    private final String name;

    private final String operatingSystem;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final String approvedPatchesComplianceLevel;

    private final Boolean approvedPatchesEnableNonSecurity;

    private final List<String> rejectedPatches;

    private final String rejectedPatchesAction;

    private final List<String> patchGroups;

    private final Instant createdDate;

    private final Instant modifiedDate;

    private final String description;

    private final List<PatchSource> sources;

    private GetPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = builder.approvedPatchesEnableNonSecurity;
        this.rejectedPatches = builder.rejectedPatches;
        this.rejectedPatchesAction = builder.rejectedPatchesAction;
        this.patchGroups = builder.patchGroups;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The ID of the retrieved patch baseline.
     * </p>
     * 
     * @return The ID of the retrieved patch baseline.
     */
    public final String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns the operating system specified for the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Returns the operating system specified for the patch baseline.
     * @see OperatingSystem
     */
    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Returns the operating system specified for the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Returns the operating system specified for the patch baseline.
     * @see OperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * A set of global filters used to exclude patches from the baseline.
     * </p>
     * 
     * @return A set of global filters used to exclude patches from the baseline.
     */
    public final PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public final PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * Returns true if the ApprovedPatches property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasApprovedPatches() {
        return approvedPatches != null && !(approvedPatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApprovedPatches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.
     */
    public final List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * Returns the specified compliance severity level for approved patches in the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Returns the specified compliance severity level for approved patches in the patch baseline.
     * @see PatchComplianceLevel
     */
    public final PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(approvedPatchesComplianceLevel);
    }

    /**
     * <p>
     * Returns the specified compliance severity level for approved patches in the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Returns the specified compliance severity level for approved patches in the patch baseline.
     * @see PatchComplianceLevel
     */
    public final String approvedPatchesComplianceLevelAsString() {
        return approvedPatchesComplianceLevel;
    }

    /**
     * <p>
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the
     * instances. The default value is 'false'. Applies to Linux instances only.
     * </p>
     * 
     * @return Indicates whether the list of approved patches includes non-security updates that should be applied to
     *         the instances. The default value is 'false'. Applies to Linux instances only.
     */
    public final Boolean approvedPatchesEnableNonSecurity() {
        return approvedPatchesEnableNonSecurity;
    }

    /**
     * Returns true if the RejectedPatches property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRejectedPatches() {
        return rejectedPatches != null && !(rejectedPatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRejectedPatches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.
     */
    public final List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if it
     * is a dependency of another package, or blocked entirely along with packages that include it as a dependency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rejectedPatchesAction} will return {@link PatchAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #rejectedPatchesActionAsString}.
     * </p>
     * 
     * @return The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only
     *         if it is a dependency of another package, or blocked entirely along with packages that include it as a
     *         dependency.
     * @see PatchAction
     */
    public final PatchAction rejectedPatchesAction() {
        return PatchAction.fromValue(rejectedPatchesAction);
    }

    /**
     * <p>
     * The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if it
     * is a dependency of another package, or blocked entirely along with packages that include it as a dependency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rejectedPatchesAction} will return {@link PatchAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #rejectedPatchesActionAsString}.
     * </p>
     * 
     * @return The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only
     *         if it is a dependency of another package, or blocked entirely along with packages that include it as a
     *         dependency.
     * @see PatchAction
     */
    public final String rejectedPatchesActionAsString() {
        return rejectedPatchesAction;
    }

    /**
     * Returns true if the PatchGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPatchGroups() {
        return patchGroups != null && !(patchGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Patch groups included in the patch baseline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPatchGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Patch groups included in the patch baseline.
     */
    public final List<String> patchGroups() {
        return patchGroups;
    }

    /**
     * <p>
     * The date the patch baseline was created.
     * </p>
     * 
     * @return The date the patch baseline was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date the patch baseline was last modified.
     * </p>
     * 
     * @return The date the patch baseline was last modified.
     */
    public final Instant modifiedDate() {
        return modifiedDate;
    }

    /**
     * <p>
     * A description of the patch baseline.
     * </p>
     * 
     * @return A description of the patch baseline.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the patches to use to update the instances, including target operating systems and source
     * repositories. Applies to Linux instances only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the patches to use to update the instances, including target operating systems and
     *         source repositories. Applies to Linux instances only.
     */
    public final List<PatchSource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovedPatches() ? approvedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesEnableNonSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(hasRejectedPatches() ? rejectedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rejectedPatchesActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchGroups() ? patchGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResponse)) {
            return false;
        }
        GetPatchBaselineResponse other = (GetPatchBaselineResponse) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(name(), other.name())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString())
                && Objects.equals(globalFilters(), other.globalFilters())
                && Objects.equals(approvalRules(), other.approvalRules()) && hasApprovedPatches() == other.hasApprovedPatches()
                && Objects.equals(approvedPatches(), other.approvedPatches())
                && Objects.equals(approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString())
                && Objects.equals(approvedPatchesEnableNonSecurity(), other.approvedPatchesEnableNonSecurity())
                && hasRejectedPatches() == other.hasRejectedPatches()
                && Objects.equals(rejectedPatches(), other.rejectedPatches())
                && Objects.equals(rejectedPatchesActionAsString(), other.rejectedPatchesActionAsString())
                && hasPatchGroups() == other.hasPatchGroups() && Objects.equals(patchGroups(), other.patchGroups())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(modifiedDate(), other.modifiedDate())
                && Objects.equals(description(), other.description()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPatchBaselineResponse").add("BaselineId", baselineId()).add("Name", name())
                .add("OperatingSystem", operatingSystemAsString()).add("GlobalFilters", globalFilters())
                .add("ApprovalRules", approvalRules()).add("ApprovedPatches", hasApprovedPatches() ? approvedPatches() : null)
                .add("ApprovedPatchesComplianceLevel", approvedPatchesComplianceLevelAsString())
                .add("ApprovedPatchesEnableNonSecurity", approvedPatchesEnableNonSecurity())
                .add("RejectedPatches", hasRejectedPatches() ? rejectedPatches() : null)
                .add("RejectedPatchesAction", rejectedPatchesActionAsString())
                .add("PatchGroups", hasPatchGroups() ? patchGroups() : null).add("CreatedDate", createdDate())
                .add("ModifiedDate", modifiedDate()).add("Description", description())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.ofNullable(clazz.cast(baselineId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "GlobalFilters":
            return Optional.ofNullable(clazz.cast(globalFilters()));
        case "ApprovalRules":
            return Optional.ofNullable(clazz.cast(approvalRules()));
        case "ApprovedPatches":
            return Optional.ofNullable(clazz.cast(approvedPatches()));
        case "ApprovedPatchesComplianceLevel":
            return Optional.ofNullable(clazz.cast(approvedPatchesComplianceLevelAsString()));
        case "ApprovedPatchesEnableNonSecurity":
            return Optional.ofNullable(clazz.cast(approvedPatchesEnableNonSecurity()));
        case "RejectedPatches":
            return Optional.ofNullable(clazz.cast(rejectedPatches()));
        case "RejectedPatchesAction":
            return Optional.ofNullable(clazz.cast(rejectedPatchesActionAsString()));
        case "PatchGroups":
            return Optional.ofNullable(clazz.cast(patchGroups()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "ModifiedDate":
            return Optional.ofNullable(clazz.cast(modifiedDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPatchBaselineResponse, T> g) {
        return obj -> g.apply((GetPatchBaselineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPatchBaselineResponse> {
        /**
         * <p>
         * The ID of the retrieved patch baseline.
         * </p>
         * 
         * @param baselineId
         *        The ID of the retrieved patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns the operating system specified for the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        Returns the operating system specified for the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Returns the operating system specified for the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        Returns the operating system specified for the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to exclude patches from the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of global filters used to exclude patches from the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchFilterGroup.Builder} avoiding the need to
         * create one manually via {@link PatchFilterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchFilterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #globalFilters(PatchFilterGroup)}.
         * 
         * @param globalFilters
         *        a consumer that will call methods on {@link PatchFilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalFilters(PatchFilterGroup)
         */
        default Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return globalFilters(PatchFilterGroup.builder().applyMutation(globalFilters).build());
        }

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * This is a convenience that creates an instance of the {@link PatchRuleGroup.Builder} avoiding the need to
         * create one manually via {@link PatchRuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchRuleGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalRules(PatchRuleGroup)}.
         * 
         * @param approvalRules
         *        a consumer that will call methods on {@link PatchRuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRules(PatchRuleGroup)
         */
        default Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return approvalRules(PatchRuleGroup.builder().applyMutation(approvalRules).build());
        }

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * Returns the specified compliance severity level for approved patches in the patch baseline.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Returns the specified compliance severity level for approved patches in the patch baseline.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel);

        /**
         * <p>
         * Returns the specified compliance severity level for approved patches in the patch baseline.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Returns the specified compliance severity level for approved patches in the patch baseline.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel);

        /**
         * <p>
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the
         * instances. The default value is 'false'. Applies to Linux instances only.
         * </p>
         * 
         * @param approvedPatchesEnableNonSecurity
         *        Indicates whether the list of approved patches includes non-security updates that should be applied to
         *        the instances. The default value is 'false'. Applies to Linux instances only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if
         * it is a dependency of another package, or blocked entirely along with packages that include it as a
         * dependency.
         * </p>
         * 
         * @param rejectedPatchesAction
         *        The action specified to take on patches included in the RejectedPatches list. A patch can be allowed
         *        only if it is a dependency of another package, or blocked entirely along with packages that include it
         *        as a dependency.
         * @see PatchAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchAction
         */
        Builder rejectedPatchesAction(String rejectedPatchesAction);

        /**
         * <p>
         * The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if
         * it is a dependency of another package, or blocked entirely along with packages that include it as a
         * dependency.
         * </p>
         * 
         * @param rejectedPatchesAction
         *        The action specified to take on patches included in the RejectedPatches list. A patch can be allowed
         *        only if it is a dependency of another package, or blocked entirely along with packages that include it
         *        as a dependency.
         * @see PatchAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchAction
         */
        Builder rejectedPatchesAction(PatchAction rejectedPatchesAction);

        /**
         * <p>
         * Patch groups included in the patch baseline.
         * </p>
         * 
         * @param patchGroups
         *        Patch groups included in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroups(Collection<String> patchGroups);

        /**
         * <p>
         * Patch groups included in the patch baseline.
         * </p>
         * 
         * @param patchGroups
         *        Patch groups included in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroups(String... patchGroups);

        /**
         * <p>
         * The date the patch baseline was created.
         * </p>
         * 
         * @param createdDate
         *        The date the patch baseline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date the patch baseline was last modified.
         * </p>
         * 
         * @param modifiedDate
         *        The date the patch baseline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedDate(Instant modifiedDate);

        /**
         * <p>
         * A description of the patch baseline.
         * </p>
         * 
         * @param description
         *        A description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the patches to use to update the instances, including target operating systems and source
         * repositories. Applies to Linux instances only.
         * </p>
         * 
         * @param sources
         *        Information about the patches to use to update the instances, including target operating systems and
         *        source repositories. Applies to Linux instances only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<PatchSource> sources);

        /**
         * <p>
         * Information about the patches to use to update the instances, including target operating systems and source
         * repositories. Applies to Linux instances only.
         * </p>
         * 
         * @param sources
         *        Information about the patches to use to update the instances, including target operating systems and
         *        source repositories. Applies to Linux instances only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(PatchSource... sources);

        /**
         * <p>
         * Information about the patches to use to update the instances, including target operating systems and source
         * repositories. Applies to Linux instances only.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchSource>.Builder} avoiding the need to
         * create one manually via {@link List<PatchSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<PatchSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<PatchSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<PatchSource>)
         */
        Builder sources(Consumer<PatchSource.Builder>... sources);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String baselineId;

        private String name;

        private String operatingSystem;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();

        private String approvedPatchesComplianceLevel;

        private Boolean approvedPatchesEnableNonSecurity;

        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();

        private String rejectedPatchesAction;

        private List<String> patchGroups = DefaultSdkAutoConstructList.getInstance();

        private Instant createdDate;

        private Instant modifiedDate;

        private String description;

        private List<PatchSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineResponse model) {
            super(model);
            baselineId(model.baselineId);
            name(model.name);
            operatingSystem(model.operatingSystem);
            globalFilters(model.globalFilters);
            approvalRules(model.approvalRules);
            approvedPatches(model.approvedPatches);
            approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            approvedPatchesEnableNonSecurity(model.approvedPatchesEnableNonSecurity);
            rejectedPatches(model.rejectedPatches);
            rejectedPatchesAction(model.rejectedPatchesAction);
            patchGroups(model.patchGroups);
            createdDate(model.createdDate);
            modifiedDate(model.modifiedDate);
            description(model.description);
            sources(model.sources);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return globalFilters != null ? globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return approvalRules != null ? approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            if (approvedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel == null ? null : approvedPatchesComplianceLevel
                    .toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Boolean getApprovedPatchesEnableNonSecurity() {
            return approvedPatchesEnableNonSecurity;
        }

        @Override
        public final Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public final void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
        }

        public final Collection<String> getRejectedPatches() {
            if (rejectedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getRejectedPatchesAction() {
            return rejectedPatchesAction;
        }

        @Override
        public final Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        @Override
        public final Builder rejectedPatchesAction(PatchAction rejectedPatchesAction) {
            this.rejectedPatchesAction(rejectedPatchesAction == null ? null : rejectedPatchesAction.toString());
            return this;
        }

        public final void setRejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
        }

        public final Collection<String> getPatchGroups() {
            if (patchGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return patchGroups;
        }

        @Override
        public final Builder patchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchGroups(String... patchGroups) {
            patchGroups(Arrays.asList(patchGroups));
            return this;
        }

        public final void setPatchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PatchSource.Builder> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources != null ? sources.stream().map(PatchSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<PatchSource> sources) {
            this.sources = PatchSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(PatchSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<PatchSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> PatchSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<PatchSource.BuilderImpl> sources) {
            this.sources = PatchSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public GetPatchBaselineResponse build() {
            return new GetPatchBaselineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
