/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssociationRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::associationId)).setter(UpdateAssociationRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::parameters)).setter(UpdateAssociationRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::documentVersion)).setter(UpdateAssociationRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::scheduleExpression)).setter(UpdateAssociationRequest.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::outputLocation)).setter(UpdateAssociationRequest.setter(Builder::outputLocation)).constructor(InstanceAssociationOutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::name)).setter(UpdateAssociationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::targets)).setter(UpdateAssociationRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationName").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::associationName)).setter(UpdateAssociationRequest.setter(Builder::associationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::associationVersion)).setter(UpdateAssociationRequest.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<String> AUTOMATION_TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationTargetParameterName").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::automationTargetParameterName)).setter(UpdateAssociationRequest.setter(Builder::automationTargetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationTargetParameterName").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::maxErrors)).setter(UpdateAssociationRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::maxConcurrency)).setter(UpdateAssociationRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceSeverity").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::complianceSeverityAsString)).setter(UpdateAssociationRequest.setter(Builder::complianceSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build()}).build();
    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncCompliance").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::syncComplianceAsString)).setter(UpdateAssociationRequest.setter(Builder::syncCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()}).build();
    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval").getter(UpdateAssociationRequest.getter(UpdateAssociationRequest::applyOnlyAtCronInterval)).setter(UpdateAssociationRequest.setter(Builder::applyOnlyAtCronInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, PARAMETERS_FIELD, DOCUMENT_VERSION_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, NAME_FIELD, TARGETS_FIELD, ASSOCIATION_NAME_FIELD, ASSOCIATION_VERSION_FIELD, AUTOMATION_TARGET_PARAMETER_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD, COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD, APPLY_ONLY_AT_CRON_INTERVAL_FIELD));
    private final String associationId;
    private final Map<String, List<String>> parameters;
    private final String documentVersion;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String name;
    private final List<Target> targets;
    private final String associationName;
    private final String associationVersion;
    private final String automationTargetParameterName;
    private final String maxErrors;
    private final String maxConcurrency;
    private final String complianceSeverity;
    private final String syncCompliance;
    private final Boolean applyOnlyAtCronInterval;

    private UpdateAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.parameters = builder.parameters;
        this.documentVersion = builder.documentVersion;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.name = builder.name;
        this.targets = builder.targets;
        this.associationName = builder.associationName;
        this.associationVersion = builder.associationVersion;
        this.automationTargetParameterName = builder.automationTargetParameterName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
    }

    public String associationId() {
        return this.associationId;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public String name() {
        return this.name;
    }

    public boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String associationName() {
        return this.associationName;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public String automationTargetParameterName() {
        return this.automationTargetParameterName;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(this.complianceSeverity);
    }

    public String complianceSeverityAsString() {
        return this.complianceSeverity;
    }

    public AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(this.syncCompliance);
    }

    public String syncComplianceAsString() {
        return this.syncCompliance;
    }

    public Boolean applyOnlyAtCronInterval() {
        return this.applyOnlyAtCronInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationTargetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnlyAtCronInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationRequest)) {
            return false;
        }
        UpdateAssociationRequest other = (UpdateAssociationRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.name(), other.name()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.associationName(), other.associationName()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.automationTargetParameterName(), other.automationTargetParameterName()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.complianceSeverityAsString(), other.complianceSeverityAsString()) && Objects.equals(this.syncComplianceAsString(), other.syncComplianceAsString()) && Objects.equals(this.applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAssociationRequest").add("AssociationId", (Object)this.associationId()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("DocumentVersion", (Object)this.documentVersion()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("Name", (Object)this.name()).add("Targets", this.hasTargets() ? this.targets() : null).add("AssociationName", (Object)this.associationName()).add("AssociationVersion", (Object)this.associationVersion()).add("AutomationTargetParameterName", (Object)this.automationTargetParameterName()).add("MaxErrors", (Object)this.maxErrors()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ComplianceSeverity", (Object)this.complianceSeverityAsString()).add("SyncCompliance", (Object)this.syncComplianceAsString()).add("ApplyOnlyAtCronInterval", (Object)this.applyOnlyAtCronInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "AutomationTargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.automationTargetParameterName()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "ComplianceSeverity": {
                return Optional.ofNullable(clazz.cast(this.complianceSeverityAsString()));
            }
            case "SyncCompliance": {
                return Optional.ofNullable(clazz.cast(this.syncComplianceAsString()));
            }
            case "ApplyOnlyAtCronInterval": {
                return Optional.ofNullable(clazz.cast(this.applyOnlyAtCronInterval()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssociationRequest, T> g) {
        return obj -> g.apply((UpdateAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String associationId;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String documentVersion;
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String name;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String associationName;
        private String associationVersion;
        private String automationTargetParameterName;
        private String maxErrors;
        private String maxConcurrency;
        private String complianceSeverity;
        private String syncCompliance;
        private Boolean applyOnlyAtCronInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.parameters(model.parameters);
            this.documentVersion(model.documentVersion);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.name(model.name);
            this.targets(model.targets);
            this.associationName(model.associationName);
            this.associationVersion(model.associationVersion);
            this.automationTargetParameterName(model.automationTargetParameterName);
            this.maxErrors(model.maxErrors);
            this.maxConcurrency(model.maxConcurrency);
            this.complianceSeverity(model.complianceSeverity);
            this.syncCompliance(model.syncCompliance);
            this.applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Target.Builder> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getAutomationTargetParameterName() {
            return this.automationTargetParameterName;
        }

        @Override
        public final Builder automationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        public final void setAutomationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getComplianceSeverity() {
            return this.complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        public final String getSyncCompliance() {
            return this.syncCompliance;
        }

        @Override
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return this.applyOnlyAtCronInterval;
        }

        @Override
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssociationRequest build() {
            return new UpdateAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssociationRequest> {
        public Builder associationId(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder documentVersion(String var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder name(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder associationName(String var1);

        public Builder associationVersion(String var1);

        public Builder automationTargetParameterName(String var1);

        public Builder maxErrors(String var1);

        public Builder maxConcurrency(String var1);

        public Builder complianceSeverity(String var1);

        public Builder complianceSeverity(AssociationComplianceSeverity var1);

        public Builder syncCompliance(String var1);

        public Builder syncCompliance(AssociationSyncCompliance var1);

        public Builder applyOnlyAtCronInterval(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

