/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemStatus;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItemSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsItemSummary> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(OpsItemSummary.getter(OpsItemSummary::createdBy)).setter(OpsItemSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(OpsItemSummary.getter(OpsItemSummary::createdTime)).setter(OpsItemSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(OpsItemSummary.getter(OpsItemSummary::lastModifiedBy)).setter(OpsItemSummary.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(OpsItemSummary.getter(OpsItemSummary::lastModifiedTime)).setter(OpsItemSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(OpsItemSummary.getter(OpsItemSummary::priority)).setter(OpsItemSummary.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(OpsItemSummary.getter(OpsItemSummary::source)).setter(OpsItemSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OpsItemSummary.getter(OpsItemSummary::statusAsString)).setter(OpsItemSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(OpsItemSummary.getter(OpsItemSummary::opsItemId)).setter(OpsItemSummary.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(OpsItemSummary.getter(OpsItemSummary::title)).setter(OpsItemSummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(OpsItemSummary.getter(OpsItemSummary::operationalData)).setter(OpsItemSummary.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(OpsItemSummary.getter(OpsItemSummary::category)).setter(OpsItemSummary.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(OpsItemSummary.getter(OpsItemSummary::severity)).setter(OpsItemSummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, PRIORITY_FIELD, SOURCE_FIELD, STATUS_FIELD, OPS_ITEM_ID_FIELD, TITLE_FIELD, OPERATIONAL_DATA_FIELD, CATEGORY_FIELD, SEVERITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String createdBy;
    private final Instant createdTime;
    private final String lastModifiedBy;
    private final Instant lastModifiedTime;
    private final Integer priority;
    private final String source;
    private final String status;
    private final String opsItemId;
    private final String title;
    private final Map<String, OpsItemDataValue> operationalData;
    private final String category;
    private final String severity;

    private OpsItemSummary(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.priority = builder.priority;
        this.source = builder.source;
        this.status = builder.status;
        this.opsItemId = builder.opsItemId;
        this.title = builder.title;
        this.operationalData = builder.operationalData;
        this.category = builder.category;
        this.severity = builder.severity;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Integer priority() {
        return this.priority;
    }

    public String source() {
        return this.source;
    }

    public OpsItemStatus status() {
        return OpsItemStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String opsItemId() {
        return this.opsItemId;
    }

    public String title() {
        return this.title;
    }

    public boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public String category() {
        return this.category;
    }

    public String severity() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemSummary)) {
            return false;
        }
        OpsItemSummary other = (OpsItemSummary)obj;
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.title(), other.title()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity());
    }

    public String toString() {
        return ToString.builder((String)"OpsItemSummary").add("CreatedBy", (Object)this.createdBy()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Priority", (Object)this.priority()).add("Source", (Object)this.source()).add("Status", (Object)this.statusAsString()).add("OpsItemId", (Object)this.opsItemId()).add("Title", (Object)this.title()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemSummary, T> g) {
        return obj -> g.apply((OpsItemSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createdBy;
        private Instant createdTime;
        private String lastModifiedBy;
        private Instant lastModifiedTime;
        private Integer priority;
        private String source;
        private String status;
        private String opsItemId;
        private String title;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private String category;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemSummary model) {
            this.createdBy(model.createdBy);
            this.createdTime(model.createdTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.priority(model.priority);
            this.source(model.source);
            this.status(model.status);
            this.opsItemId(model.opsItemId);
            this.title(model.title);
            this.operationalData(model.operationalData);
            this.category(model.category);
            this.severity(model.severity);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OpsItemStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            if (this.operationalData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.operationalData != null ? CollectionUtils.mapValues(this.operationalData, OpsItemDataValue::toBuilder) : null;
        }

        @Override
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public OpsItemSummary build() {
            return new OpsItemSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItemSummary> {
        public Builder createdBy(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder priority(Integer var1);

        public Builder source(String var1);

        public Builder status(String var1);

        public Builder status(OpsItemStatus var1);

        public Builder opsItemId(String var1);

        public Builder title(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder category(String var1);

        public Builder severity(String var1);
    }
}

