/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ComplianceSummaryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComplianceSummariesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListComplianceSummariesResponse> {
    private static final SdkField<List<ComplianceSummaryItem>> COMPLIANCE_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ComplianceSummaryItems").getter(ListComplianceSummariesResponse.getter(ListComplianceSummariesResponse::complianceSummaryItems)).setter(ListComplianceSummariesResponse.setter(Builder::complianceSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComplianceSummaryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListComplianceSummariesResponse.getter(ListComplianceSummariesResponse::nextToken)).setter(ListComplianceSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ComplianceSummaryItem> complianceSummaryItems;
    private final String nextToken;

    private ListComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.complianceSummaryItems = builder.complianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public boolean hasComplianceSummaryItems() {
        return this.complianceSummaryItems != null && !(this.complianceSummaryItems instanceof SdkAutoConstructList);
    }

    public List<ComplianceSummaryItem> complianceSummaryItems() {
        return this.complianceSummaryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComplianceSummaryItems() ? this.complianceSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceSummariesResponse)) {
            return false;
        }
        ListComplianceSummariesResponse other = (ListComplianceSummariesResponse)((Object)obj);
        return this.hasComplianceSummaryItems() == other.hasComplianceSummaryItems() && Objects.equals(this.complianceSummaryItems(), other.complianceSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListComplianceSummariesResponse").add("ComplianceSummaryItems", this.hasComplianceSummaryItems() ? this.complianceSummaryItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.complianceSummaryItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceSummariesResponse, T> g) {
        return obj -> g.apply((ListComplianceSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ComplianceSummaryItem> complianceSummaryItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceSummariesResponse model) {
            super(model);
            this.complianceSummaryItems(model.complianceSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ComplianceSummaryItem.Builder> getComplianceSummaryItems() {
            if (this.complianceSummaryItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.complianceSummaryItems != null ? (Collection)this.complianceSummaryItems.stream().map(ComplianceSummaryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder complianceSummaryItems(Collection<ComplianceSummaryItem> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copy(complianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(ComplianceSummaryItem ... complianceSummaryItems) {
            this.complianceSummaryItems(Arrays.asList(complianceSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder> ... complianceSummaryItems) {
            this.complianceSummaryItems(Stream.of(complianceSummaryItems).map(c -> (ComplianceSummaryItem)((ComplianceSummaryItem.Builder)ComplianceSummaryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceSummaryItems(Collection<ComplianceSummaryItem.BuilderImpl> complianceSummaryItems) {
            this.complianceSummaryItems = ComplianceSummaryItemListCopier.copyFromBuilder(complianceSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceSummariesResponse build() {
            return new ListComplianceSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComplianceSummariesResponse> {
        public Builder complianceSummaryItems(Collection<ComplianceSummaryItem> var1);

        public Builder complianceSummaryItems(ComplianceSummaryItem ... var1);

        public Builder complianceSummaryItems(Consumer<ComplianceSummaryItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

