/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.PatchAction;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchGroupListCopier;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.services.ssm.model.PatchSource;
import software.amazon.awssdk.services.ssm.model.PatchSourceListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPatchBaselineResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetPatchBaselineResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::baselineId)).setter(GetPatchBaselineResponse.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::name)).setter(GetPatchBaselineResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::operatingSystemAsString)).setter(GetPatchBaselineResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalFilters").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::globalFilters)).setter(GetPatchBaselineResponse.setter(Builder::globalFilters)).constructor(PatchFilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()}).build();
    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalRules").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::approvalRules)).setter(GetPatchBaselineResponse.setter(Builder::approvalRules)).constructor(PatchRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()}).build();
    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApprovedPatches").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::approvedPatches)).setter(GetPatchBaselineResponse.setter(Builder::approvedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovedPatchesComplianceLevel").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::approvedPatchesComplianceLevelAsString)).setter(GetPatchBaselineResponse.setter(Builder::approvedPatchesComplianceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel").build()}).build();
    private static final SdkField<Boolean> APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApprovedPatchesEnableNonSecurity").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::approvedPatchesEnableNonSecurity)).setter(GetPatchBaselineResponse.setter(Builder::approvedPatchesEnableNonSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesEnableNonSecurity").build()}).build();
    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RejectedPatches").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::rejectedPatches)).setter(GetPatchBaselineResponse.setter(Builder::rejectedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REJECTED_PATCHES_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RejectedPatchesAction").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::rejectedPatchesActionAsString)).setter(GetPatchBaselineResponse.setter(Builder::rejectedPatchesAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatchesAction").build()}).build();
    private static final SdkField<List<String>> PATCH_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PatchGroups").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::patchGroups)).setter(GetPatchBaselineResponse.setter(Builder::patchGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::createdDate)).setter(GetPatchBaselineResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedDate").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::modifiedDate)).setter(GetPatchBaselineResponse.setter(Builder::modifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::description)).setter(GetPatchBaselineResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<PatchSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(GetPatchBaselineResponse.getter(GetPatchBaselineResponse::sources)).setter(GetPatchBaselineResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD, NAME_FIELD, OPERATING_SYSTEM_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD, APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD, REJECTED_PATCHES_FIELD, REJECTED_PATCHES_ACTION_FIELD, PATCH_GROUPS_FIELD, CREATED_DATE_FIELD, MODIFIED_DATE_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD));
    private final String baselineId;
    private final String name;
    private final String operatingSystem;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final String approvedPatchesComplianceLevel;
    private final Boolean approvedPatchesEnableNonSecurity;
    private final List<String> rejectedPatches;
    private final String rejectedPatchesAction;
    private final List<String> patchGroups;
    private final Instant createdDate;
    private final Instant modifiedDate;
    private final String description;
    private final List<PatchSource> sources;

    private GetPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.name = builder.name;
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = builder.approvedPatchesEnableNonSecurity;
        this.rejectedPatches = builder.rejectedPatches;
        this.rejectedPatchesAction = builder.rejectedPatchesAction;
        this.patchGroups = builder.patchGroups;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.description = builder.description;
        this.sources = builder.sources;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String name() {
        return this.name;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public boolean hasApprovedPatches() {
        return this.approvedPatches != null && !(this.approvedPatches instanceof SdkAutoConstructList);
    }

    public List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(this.approvedPatchesComplianceLevel);
    }

    public String approvedPatchesComplianceLevelAsString() {
        return this.approvedPatchesComplianceLevel;
    }

    public Boolean approvedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public boolean hasRejectedPatches() {
        return this.rejectedPatches != null && !(this.rejectedPatches instanceof SdkAutoConstructList);
    }

    public List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public PatchAction rejectedPatchesAction() {
        return PatchAction.fromValue(this.rejectedPatchesAction);
    }

    public String rejectedPatchesActionAsString() {
        return this.rejectedPatchesAction;
    }

    public boolean hasPatchGroups() {
        return this.patchGroups != null && !(this.patchGroups instanceof SdkAutoConstructList);
    }

    public List<String> patchGroups() {
        return this.patchGroups;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant modifiedDate() {
        return this.modifiedDate;
    }

    public String description() {
        return this.description;
    }

    public boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public List<PatchSource> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovedPatches() ? this.approvedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesEnableNonSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRejectedPatches() ? this.rejectedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedPatchesActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatchGroups() ? this.patchGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineResponse)) {
            return false;
        }
        GetPatchBaselineResponse other = (GetPatchBaselineResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.globalFilters(), other.globalFilters()) && Objects.equals(this.approvalRules(), other.approvalRules()) && this.hasApprovedPatches() == other.hasApprovedPatches() && Objects.equals(this.approvedPatches(), other.approvedPatches()) && Objects.equals(this.approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString()) && Objects.equals(this.approvedPatchesEnableNonSecurity(), other.approvedPatchesEnableNonSecurity()) && this.hasRejectedPatches() == other.hasRejectedPatches() && Objects.equals(this.rejectedPatches(), other.rejectedPatches()) && Objects.equals(this.rejectedPatchesActionAsString(), other.rejectedPatchesActionAsString()) && this.hasPatchGroups() == other.hasPatchGroups() && Objects.equals(this.patchGroups(), other.patchGroups()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate()) && Objects.equals(this.description(), other.description()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public String toString() {
        return ToString.builder((String)"GetPatchBaselineResponse").add("BaselineId", (Object)this.baselineId()).add("Name", (Object)this.name()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("GlobalFilters", (Object)this.globalFilters()).add("ApprovalRules", (Object)this.approvalRules()).add("ApprovedPatches", this.hasApprovedPatches() ? this.approvedPatches() : null).add("ApprovedPatchesComplianceLevel", (Object)this.approvedPatchesComplianceLevelAsString()).add("ApprovedPatchesEnableNonSecurity", (Object)this.approvedPatchesEnableNonSecurity()).add("RejectedPatches", this.hasRejectedPatches() ? this.rejectedPatches() : null).add("RejectedPatchesAction", (Object)this.rejectedPatchesActionAsString()).add("PatchGroups", this.hasPatchGroups() ? this.patchGroups() : null).add("CreatedDate", (Object)this.createdDate()).add("ModifiedDate", (Object)this.modifiedDate()).add("Description", (Object)this.description()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "GlobalFilters": {
                return Optional.ofNullable(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.ofNullable(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.ofNullable(clazz.cast(this.approvedPatches()));
            }
            case "ApprovedPatchesComplianceLevel": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesComplianceLevelAsString()));
            }
            case "ApprovedPatchesEnableNonSecurity": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesEnableNonSecurity()));
            }
            case "RejectedPatches": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatches()));
            }
            case "RejectedPatchesAction": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatchesActionAsString()));
            }
            case "PatchGroups": {
                return Optional.ofNullable(clazz.cast(this.patchGroups()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.modifiedDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPatchBaselineResponse, T> g) {
        return obj -> g.apply((GetPatchBaselineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String name;
        private String operatingSystem;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();
        private String approvedPatchesComplianceLevel;
        private Boolean approvedPatchesEnableNonSecurity;
        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();
        private String rejectedPatchesAction;
        private List<String> patchGroups = DefaultSdkAutoConstructList.getInstance();
        private Instant createdDate;
        private Instant modifiedDate;
        private String description;
        private List<PatchSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineResponse model) {
            super(model);
            this.baselineId(model.baselineId);
            this.name(model.name);
            this.operatingSystem(model.operatingSystem);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            this.approvedPatchesEnableNonSecurity(model.approvedPatchesEnableNonSecurity);
            this.rejectedPatches(model.rejectedPatches);
            this.rejectedPatchesAction(model.rejectedPatchesAction);
            this.patchGroups(model.patchGroups);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
            this.description(model.description);
            this.sources(model.sources);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        public final Collection<String> getApprovedPatches() {
            if (this.approvedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvedPatches;
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        public final String getApprovedPatchesComplianceLevel() {
            return this.approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel == null ? null : approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        public final Boolean getApprovedPatchesEnableNonSecurity() {
            return this.approvedPatchesEnableNonSecurity;
        }

        @Override
        public final Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public final void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
        }

        public final Collection<String> getRejectedPatches() {
            if (this.rejectedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rejectedPatches;
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        public final String getRejectedPatchesAction() {
            return this.rejectedPatchesAction;
        }

        @Override
        public final Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        @Override
        public final Builder rejectedPatchesAction(PatchAction rejectedPatchesAction) {
            this.rejectedPatchesAction(rejectedPatchesAction == null ? null : rejectedPatchesAction.toString());
            return this;
        }

        public final void setRejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
        }

        public final Collection<String> getPatchGroups() {
            if (this.patchGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.patchGroups;
        }

        @Override
        public final Builder patchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchGroups(String ... patchGroups) {
            this.patchGroups(Arrays.asList(patchGroups));
            return this;
        }

        public final void setPatchGroups(Collection<String> patchGroups) {
            this.patchGroups = PatchGroupListCopier.copy(patchGroups);
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<PatchSource.Builder> getSources() {
            if (this.sources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sources != null ? (Collection)this.sources.stream().map(PatchSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<PatchSource> sources) {
            this.sources = PatchSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(PatchSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<PatchSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (PatchSource)((PatchSource.Builder)PatchSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<PatchSource.BuilderImpl> sources) {
            this.sources = PatchSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public GetPatchBaselineResponse build() {
            return new GetPatchBaselineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder name(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder globalFilters(PatchFilterGroup var1);

        default public Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return this.globalFilters((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().applyMutation(globalFilters)).build());
        }

        public Builder approvalRules(PatchRuleGroup var1);

        default public Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return this.approvalRules((PatchRuleGroup)((PatchRuleGroup.Builder)PatchRuleGroup.builder().applyMutation(approvalRules)).build());
        }

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder approvedPatchesComplianceLevel(String var1);

        public Builder approvedPatchesComplianceLevel(PatchComplianceLevel var1);

        public Builder approvedPatchesEnableNonSecurity(Boolean var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder rejectedPatchesAction(String var1);

        public Builder rejectedPatchesAction(PatchAction var1);

        public Builder patchGroups(Collection<String> var1);

        public Builder patchGroups(String ... var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);

        public Builder description(String var1);

        public Builder sources(Collection<PatchSource> var1);

        public Builder sources(PatchSource ... var1);

        public Builder sources(Consumer<PatchSource.Builder> ... var1);
    }
}

