/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstancePatchesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeInstancePatchesResponse> {
    private static final SdkField<List<PatchComplianceData>> PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Patches").getter(DescribeInstancePatchesResponse.getter(DescribeInstancePatchesResponse::patches)).setter(DescribeInstancePatchesResponse.setter(Builder::patches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchComplianceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstancePatchesResponse.getter(DescribeInstancePatchesResponse::nextToken)).setter(DescribeInstancePatchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PatchComplianceData> patches;
    private final String nextToken;

    private DescribeInstancePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPatches() {
        return this.patches != null && !(this.patches instanceof SdkAutoConstructList);
    }

    public List<PatchComplianceData> patches() {
        return this.patches;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatches() ? this.patches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchesResponse)) {
            return false;
        }
        DescribeInstancePatchesResponse other = (DescribeInstancePatchesResponse)((Object)obj);
        return this.hasPatches() == other.hasPatches() && Objects.equals(this.patches(), other.patches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstancePatchesResponse").add("Patches", this.hasPatches() ? this.patches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patches": {
                return Optional.ofNullable(clazz.cast(this.patches()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePatchesResponse, T> g) {
        return obj -> g.apply((DescribeInstancePatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<PatchComplianceData> patches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchesResponse model) {
            super(model);
            this.patches(model.patches);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchComplianceData.Builder> getPatches() {
            if (this.patches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.patches != null ? (Collection)this.patches.stream().map(PatchComplianceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<PatchComplianceData> patches) {
            this.patches = PatchComplianceDataListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(PatchComplianceData ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Consumer<PatchComplianceData.Builder> ... patches) {
            this.patches(Stream.of(patches).map(c -> (PatchComplianceData)((PatchComplianceData.Builder)PatchComplianceData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatches(Collection<PatchComplianceData.BuilderImpl> patches) {
            this.patches = PatchComplianceDataListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancePatchesResponse build() {
            return new DescribeInstancePatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstancePatchesResponse> {
        public Builder patches(Collection<PatchComplianceData> var1);

        public Builder patches(PatchComplianceData ... var1);

        public Builder patches(Consumer<PatchComplianceData.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

