/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingInfo> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(LoggingInfo.getter(LoggingInfo::s3BucketName)).setter(LoggingInfo.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(LoggingInfo.getter(LoggingInfo::s3KeyPrefix)).setter(LoggingInfo.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> S3_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Region").getter(LoggingInfo.getter(LoggingInfo::s3Region)).setter(LoggingInfo.setter(Builder::s3Region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, S3_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String s3Region;

    private LoggingInfo(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.s3Region = builder.s3Region;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String s3Region() {
        return this.s3Region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        LoggingInfo other = (LoggingInfo)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.s3Region(), other.s3Region());
    }

    public String toString() {
        return ToString.builder((String)"LoggingInfo").add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("S3Region", (Object)this.s3Region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "S3Region": {
                return Optional.ofNullable(clazz.cast(this.s3Region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingInfo, T> g) {
        return obj -> g.apply((LoggingInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3KeyPrefix;
        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingInfo model) {
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.s3Region(model.s3Region);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        public LoggingInfo build() {
            return new LoggingInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingInfo> {
        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder s3Region(String var1);
    }
}

