/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationVersionInfo;
import software.amazon.awssdk.services.ssm.model.AssociationVersionListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociationVersionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListAssociationVersionsResponse> {
    private static final SdkField<List<AssociationVersionInfo>> ASSOCIATION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationVersions").getter(ListAssociationVersionsResponse.getter(ListAssociationVersionsResponse::associationVersions)).setter(ListAssociationVersionsResponse.setter(Builder::associationVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationVersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssociationVersionsResponse.getter(ListAssociationVersionsResponse::nextToken)).setter(ListAssociationVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociationVersionInfo> associationVersions;
    private final String nextToken;

    private ListAssociationVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.associationVersions = builder.associationVersions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAssociationVersions() {
        return this.associationVersions != null && !(this.associationVersions instanceof SdkAutoConstructList);
    }

    public List<AssociationVersionInfo> associationVersions() {
        return this.associationVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationVersionsResponse)) {
            return false;
        }
        ListAssociationVersionsResponse other = (ListAssociationVersionsResponse)((Object)obj);
        return Objects.equals(this.associationVersions(), other.associationVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAssociationVersionsResponse").add("AssociationVersions", this.associationVersions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationVersions": {
                return Optional.ofNullable(clazz.cast(this.associationVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationVersionsResponse, T> g) {
        return obj -> g.apply((ListAssociationVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<AssociationVersionInfo> associationVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationVersionsResponse model) {
            super(model);
            this.associationVersions(model.associationVersions);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationVersionInfo.Builder> getAssociationVersions() {
            return this.associationVersions != null ? (Collection)this.associationVersions.stream().map(AssociationVersionInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationVersions(Collection<AssociationVersionInfo> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copy(associationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(AssociationVersionInfo ... associationVersions) {
            this.associationVersions(Arrays.asList(associationVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationVersions(Consumer<AssociationVersionInfo.Builder> ... associationVersions) {
            this.associationVersions(Stream.of(associationVersions).map(c -> (AssociationVersionInfo)((AssociationVersionInfo.Builder)AssociationVersionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationVersions(Collection<AssociationVersionInfo.BuilderImpl> associationVersions) {
            this.associationVersions = AssociationVersionListCopier.copyFromBuilder(associationVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssociationVersionsResponse build() {
            return new ListAssociationVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociationVersionsResponse> {
        public Builder associationVersions(Collection<AssociationVersionInfo> var1);

        public Builder associationVersions(AssociationVersionInfo ... var1);

        public Builder associationVersions(Consumer<AssociationVersionInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

