/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(InstanceAssociation.getter(InstanceAssociation::associationId)).setter(InstanceAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceAssociation.getter(InstanceAssociation::instanceId)).setter(InstanceAssociation.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(InstanceAssociation.getter(InstanceAssociation::content)).setter(InstanceAssociation.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(InstanceAssociation.getter(InstanceAssociation::associationVersion)).setter(InstanceAssociation.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, INSTANCE_ID_FIELD, CONTENT_FIELD, ASSOCIATION_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String instanceId;
    private final String content;
    private final String associationVersion;

    private InstanceAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.instanceId = builder.instanceId;
        this.content = builder.content;
        this.associationVersion = builder.associationVersion;
    }

    public String associationId() {
        return this.associationId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String content() {
        return this.content;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociation)) {
            return false;
        }
        InstanceAssociation other = (InstanceAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.associationVersion(), other.associationVersion());
    }

    public String toString() {
        return ToString.builder((String)"InstanceAssociation").add("AssociationId", (Object)this.associationId()).add("InstanceId", (Object)this.instanceId()).add("Content", (Object)this.content()).add("AssociationVersion", (Object)this.associationVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAssociation, T> g) {
        return obj -> g.apply((InstanceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String instanceId;
        private String content;
        private String associationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociation model) {
            this.associationId(model.associationId);
            this.instanceId(model.instanceId);
            this.content(model.content);
            this.associationVersion(model.associationVersion);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public InstanceAssociation build() {
            return new InstanceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceAssociation> {
        public Builder associationId(String var1);

        public Builder instanceId(String var1);

        public Builder content(String var1);

        public Builder associationVersion(String var1);
    }
}

