/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CommandStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    SUCCESS("Success"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    TIMED_OUT("TimedOut"),
    CANCELLING("Cancelling"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CommandStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommandStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CommandStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommandStatus> knownValues() {
        return Stream.of(CommandStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

