/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryDeletionStatusItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryDeletionStatusItem> {
    private static final SdkField<String> DELETION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::deletionId)).setter(InventoryDeletionStatusItem.setter(Builder::deletionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionId").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::typeName)).setter(InventoryDeletionStatusItem.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<Instant> DELETION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::deletionStartTime)).setter(InventoryDeletionStatusItem.setter(Builder::deletionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStartTime").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::lastStatusAsString)).setter(InventoryDeletionStatusItem.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatus").build()}).build();
    private static final SdkField<String> LAST_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::lastStatusMessage)).setter(InventoryDeletionStatusItem.setter(Builder::lastStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusMessage").build()}).build();
    private static final SdkField<InventoryDeletionSummary> DELETION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::deletionSummary)).setter(InventoryDeletionStatusItem.setter(Builder::deletionSummary)).constructor(InventoryDeletionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionSummary").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InventoryDeletionStatusItem.getter(InventoryDeletionStatusItem::lastStatusUpdateTime)).setter(InventoryDeletionStatusItem.setter(Builder::lastStatusUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_ID_FIELD, TYPE_NAME_FIELD, DELETION_START_TIME_FIELD, LAST_STATUS_FIELD, LAST_STATUS_MESSAGE_FIELD, DELETION_SUMMARY_FIELD, LAST_STATUS_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deletionId;
    private final String typeName;
    private final Instant deletionStartTime;
    private final String lastStatus;
    private final String lastStatusMessage;
    private final InventoryDeletionSummary deletionSummary;
    private final Instant lastStatusUpdateTime;

    private InventoryDeletionStatusItem(BuilderImpl builder) {
        this.deletionId = builder.deletionId;
        this.typeName = builder.typeName;
        this.deletionStartTime = builder.deletionStartTime;
        this.lastStatus = builder.lastStatus;
        this.lastStatusMessage = builder.lastStatusMessage;
        this.deletionSummary = builder.deletionSummary;
        this.lastStatusUpdateTime = builder.lastStatusUpdateTime;
    }

    public String deletionId() {
        return this.deletionId;
    }

    public String typeName() {
        return this.typeName;
    }

    public Instant deletionStartTime() {
        return this.deletionStartTime;
    }

    public InventoryDeletionStatus lastStatus() {
        return InventoryDeletionStatus.fromValue(this.lastStatus);
    }

    public String lastStatusAsString() {
        return this.lastStatus;
    }

    public String lastStatusMessage() {
        return this.lastStatusMessage;
    }

    public InventoryDeletionSummary deletionSummary() {
        return this.deletionSummary;
    }

    public Instant lastStatusUpdateTime() {
        return this.lastStatusUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionStatusItem)) {
            return false;
        }
        InventoryDeletionStatusItem other = (InventoryDeletionStatusItem)obj;
        return Objects.equals(this.deletionId(), other.deletionId()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.deletionStartTime(), other.deletionStartTime()) && Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.lastStatusMessage(), other.lastStatusMessage()) && Objects.equals(this.deletionSummary(), other.deletionSummary()) && Objects.equals(this.lastStatusUpdateTime(), other.lastStatusUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"InventoryDeletionStatusItem").add("DeletionId", (Object)this.deletionId()).add("TypeName", (Object)this.typeName()).add("DeletionStartTime", (Object)this.deletionStartTime()).add("LastStatus", (Object)this.lastStatusAsString()).add("LastStatusMessage", (Object)this.lastStatusMessage()).add("DeletionSummary", (Object)this.deletionSummary()).add("LastStatusUpdateTime", (Object)this.lastStatusUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletionId": {
                return Optional.ofNullable(clazz.cast(this.deletionId()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DeletionStartTime": {
                return Optional.ofNullable(clazz.cast(this.deletionStartTime()));
            }
            case "LastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "LastStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lastStatusMessage()));
            }
            case "DeletionSummary": {
                return Optional.ofNullable(clazz.cast(this.deletionSummary()));
            }
            case "LastStatusUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastStatusUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionStatusItem, T> g) {
        return obj -> g.apply((InventoryDeletionStatusItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deletionId;
        private String typeName;
        private Instant deletionStartTime;
        private String lastStatus;
        private String lastStatusMessage;
        private InventoryDeletionSummary deletionSummary;
        private Instant lastStatusUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionStatusItem model) {
            this.deletionId(model.deletionId);
            this.typeName(model.typeName);
            this.deletionStartTime(model.deletionStartTime);
            this.lastStatus(model.lastStatus);
            this.lastStatusMessage(model.lastStatusMessage);
            this.deletionSummary(model.deletionSummary);
            this.lastStatusUpdateTime(model.lastStatusUpdateTime);
        }

        public final String getDeletionId() {
            return this.deletionId;
        }

        @Override
        public final Builder deletionId(String deletionId) {
            this.deletionId = deletionId;
            return this;
        }

        public final void setDeletionId(String deletionId) {
            this.deletionId = deletionId;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final Instant getDeletionStartTime() {
            return this.deletionStartTime;
        }

        @Override
        public final Builder deletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
            return this;
        }

        public final void setDeletionStartTime(Instant deletionStartTime) {
            this.deletionStartTime = deletionStartTime;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(InventoryDeletionStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final String getLastStatusMessage() {
            return this.lastStatusMessage;
        }

        @Override
        public final Builder lastStatusMessage(String lastStatusMessage) {
            this.lastStatusMessage = lastStatusMessage;
            return this;
        }

        public final void setLastStatusMessage(String lastStatusMessage) {
            this.lastStatusMessage = lastStatusMessage;
        }

        public final InventoryDeletionSummary.Builder getDeletionSummary() {
            return this.deletionSummary != null ? this.deletionSummary.toBuilder() : null;
        }

        @Override
        public final Builder deletionSummary(InventoryDeletionSummary deletionSummary) {
            this.deletionSummary = deletionSummary;
            return this;
        }

        public final void setDeletionSummary(InventoryDeletionSummary.BuilderImpl deletionSummary) {
            this.deletionSummary = deletionSummary != null ? deletionSummary.build() : null;
        }

        public final Instant getLastStatusUpdateTime() {
            return this.lastStatusUpdateTime;
        }

        @Override
        public final Builder lastStatusUpdateTime(Instant lastStatusUpdateTime) {
            this.lastStatusUpdateTime = lastStatusUpdateTime;
            return this;
        }

        public final void setLastStatusUpdateTime(Instant lastStatusUpdateTime) {
            this.lastStatusUpdateTime = lastStatusUpdateTime;
        }

        public InventoryDeletionStatusItem build() {
            return new InventoryDeletionStatusItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryDeletionStatusItem> {
        public Builder deletionId(String var1);

        public Builder typeName(String var1);

        public Builder deletionStartTime(Instant var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(InventoryDeletionStatus var1);

        public Builder lastStatusMessage(String var1);

        public Builder deletionSummary(InventoryDeletionSummary var1);

        default public Builder deletionSummary(Consumer<InventoryDeletionSummary.Builder> deletionSummary) {
            return this.deletionSummary((InventoryDeletionSummary)((InventoryDeletionSummary.Builder)InventoryDeletionSummary.builder().applyMutation(deletionSummary)).build());
        }

        public Builder lastStatusUpdateTime(Instant var1);
    }
}

