/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowIdentity> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::windowId)).setter(MaintenanceWindowIdentity.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::name)).setter(MaintenanceWindowIdentity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::description)).setter(MaintenanceWindowIdentity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::enabled)).setter(MaintenanceWindowIdentity.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::duration)).setter(MaintenanceWindowIdentity.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::cutoff)).setter(MaintenanceWindowIdentity.setter(Builder::cutoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::schedule)).setter(MaintenanceWindowIdentity.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::scheduleTimezone)).setter(MaintenanceWindowIdentity.setter(Builder::scheduleTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::scheduleOffset)).setter(MaintenanceWindowIdentity.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::endDate)).setter(MaintenanceWindowIdentity.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::startDate)).setter(MaintenanceWindowIdentity.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> NEXT_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MaintenanceWindowIdentity.getter(MaintenanceWindowIdentity::nextExecutionTime)).setter(MaintenanceWindowIdentity.setter(Builder::nextExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextExecutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENABLED_FIELD, DURATION_FIELD, CUTOFF_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, END_DATE_FIELD, START_DATE_FIELD, NEXT_EXECUTION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String name;
    private final String description;
    private final Boolean enabled;
    private final Integer duration;
    private final Integer cutoff;
    private final String schedule;
    private final String scheduleTimezone;
    private final Integer scheduleOffset;
    private final String endDate;
    private final String startDate;
    private final String nextExecutionTime;

    private MaintenanceWindowIdentity(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.endDate = builder.endDate;
        this.startDate = builder.startDate;
        this.nextExecutionTime = builder.nextExecutionTime;
    }

    public String windowId() {
        return this.windowId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer cutoff() {
        return this.cutoff;
    }

    public String schedule() {
        return this.schedule;
    }

    public String scheduleTimezone() {
        return this.scheduleTimezone;
    }

    public Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public String endDate() {
        return this.endDate;
    }

    public String startDate() {
        return this.startDate;
    }

    public String nextExecutionTime() {
        return this.nextExecutionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextExecutionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowIdentity)) {
            return false;
        }
        MaintenanceWindowIdentity other = (MaintenanceWindowIdentity)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduleTimezone(), other.scheduleTimezone()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.nextExecutionTime(), other.nextExecutionTime());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowIdentity").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Enabled", (Object)this.enabled()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("Schedule", (Object)this.schedule()).add("ScheduleTimezone", (Object)this.scheduleTimezone()).add("ScheduleOffset", (Object)this.scheduleOffset()).add("EndDate", (Object)this.endDate()).add("StartDate", (Object)this.startDate()).add("NextExecutionTime", (Object)this.nextExecutionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduleTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleTimezone()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "NextExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.nextExecutionTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private Boolean enabled;
        private Integer duration;
        private Integer cutoff;
        private String schedule;
        private String scheduleTimezone;
        private Integer scheduleOffset;
        private String endDate;
        private String startDate;
        private String nextExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowIdentity model) {
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.enabled(model.enabled);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.schedule(model.schedule);
            this.scheduleTimezone(model.scheduleTimezone);
            this.scheduleOffset(model.scheduleOffset);
            this.endDate(model.endDate);
            this.startDate(model.startDate);
            this.nextExecutionTime(model.nextExecutionTime);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getScheduleTimezone() {
            return this.scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getNextExecutionTime() {
            return this.nextExecutionTime;
        }

        @Override
        public final Builder nextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
            return this;
        }

        public final void setNextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        public MaintenanceWindowIdentity build() {
            return new MaintenanceWindowIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowIdentity> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder schedule(String var1);

        public Builder scheduleTimezone(String var1);

        public Builder scheduleOffset(Integer var1);

        public Builder endDate(String var1);

        public Builder startDate(String var1);

        public Builder nextExecutionTime(String var1);
    }
}

