/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

public class DescribeInstanceInformationPublisher
implements SdkPublisher<DescribeInstanceInformationResponse> {
    private final SsmAsyncClient client;
    private final DescribeInstanceInformationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceInformationPublisher(SsmAsyncClient client, DescribeInstanceInformationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceInformationPublisher(SsmAsyncClient client, DescribeInstanceInformationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceInformationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceInformationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceInformation> instanceInformationList() {
        Function<DescribeInstanceInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceInformationList() != null) {
                return response.instanceInformationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceInformationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeInstanceInformationPublisher resume(DescribeInstanceInformationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstanceInformationPublisher(this.client, (DescribeInstanceInformationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstanceInformationPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeInstanceInformationResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeInstanceInformationResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceInformationResponse> {
        private DescribeInstanceInformationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceInformationResponse> nextPage(DescribeInstanceInformationResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceInformationPublisher.this.client.describeInstanceInformation(DescribeInstanceInformationPublisher.this.firstRequest);
            }
            return DescribeInstanceInformationPublisher.this.client.describeInstanceInformation((DescribeInstanceInformationRequest)((Object)DescribeInstanceInformationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

