/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowdevicemanagement.model.IpAddressAssignment;
import software.amazon.awssdk.services.snowdevicemanagement.model.PhysicalConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhysicalNetworkInterface> {
    private static final SdkField<String> DEFAULT_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultGateway").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::defaultGateway)).setter(PhysicalNetworkInterface.setter(Builder::defaultGateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultGateway").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::ipAddress)).setter(PhysicalNetworkInterface.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> IP_ADDRESS_ASSIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressAssignment").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::ipAddressAssignmentAsString)).setter(PhysicalNetworkInterface.setter(Builder::ipAddressAssignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressAssignment").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("macAddress").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::macAddress)).setter(PhysicalNetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final SdkField<String> NETMASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("netmask").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::netmask)).setter(PhysicalNetworkInterface.setter(Builder::netmask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("netmask").build()}).build();
    private static final SdkField<String> PHYSICAL_CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("physicalConnectorType").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::physicalConnectorTypeAsString)).setter(PhysicalNetworkInterface.setter(Builder::physicalConnectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectorType").build()}).build();
    private static final SdkField<String> PHYSICAL_NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("physicalNetworkInterfaceId").getter(PhysicalNetworkInterface.getter(PhysicalNetworkInterface::physicalNetworkInterfaceId)).setter(PhysicalNetworkInterface.setter(Builder::physicalNetworkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalNetworkInterfaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_GATEWAY_FIELD, IP_ADDRESS_FIELD, IP_ADDRESS_ASSIGNMENT_FIELD, MAC_ADDRESS_FIELD, NETMASK_FIELD, PHYSICAL_CONNECTOR_TYPE_FIELD, PHYSICAL_NETWORK_INTERFACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhysicalNetworkInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultGateway;
    private final String ipAddress;
    private final String ipAddressAssignment;
    private final String macAddress;
    private final String netmask;
    private final String physicalConnectorType;
    private final String physicalNetworkInterfaceId;

    private PhysicalNetworkInterface(BuilderImpl builder) {
        this.defaultGateway = builder.defaultGateway;
        this.ipAddress = builder.ipAddress;
        this.ipAddressAssignment = builder.ipAddressAssignment;
        this.macAddress = builder.macAddress;
        this.netmask = builder.netmask;
        this.physicalConnectorType = builder.physicalConnectorType;
        this.physicalNetworkInterfaceId = builder.physicalNetworkInterfaceId;
    }

    public final String defaultGateway() {
        return this.defaultGateway;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final IpAddressAssignment ipAddressAssignment() {
        return IpAddressAssignment.fromValue(this.ipAddressAssignment);
    }

    public final String ipAddressAssignmentAsString() {
        return this.ipAddressAssignment;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String netmask() {
        return this.netmask;
    }

    public final PhysicalConnectorType physicalConnectorType() {
        return PhysicalConnectorType.fromValue(this.physicalConnectorType);
    }

    public final String physicalConnectorTypeAsString() {
        return this.physicalConnectorType;
    }

    public final String physicalNetworkInterfaceId() {
        return this.physicalNetworkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultGateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressAssignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.netmask());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalNetworkInterfaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalNetworkInterface)) {
            return false;
        }
        PhysicalNetworkInterface other = (PhysicalNetworkInterface)obj;
        return Objects.equals(this.defaultGateway(), other.defaultGateway()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.ipAddressAssignmentAsString(), other.ipAddressAssignmentAsString()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.netmask(), other.netmask()) && Objects.equals(this.physicalConnectorTypeAsString(), other.physicalConnectorTypeAsString()) && Objects.equals(this.physicalNetworkInterfaceId(), other.physicalNetworkInterfaceId());
    }

    public final String toString() {
        return ToString.builder((String)"PhysicalNetworkInterface").add("DefaultGateway", (Object)this.defaultGateway()).add("IpAddress", (Object)this.ipAddress()).add("IpAddressAssignment", (Object)this.ipAddressAssignmentAsString()).add("MacAddress", (Object)this.macAddress()).add("Netmask", (Object)this.netmask()).add("PhysicalConnectorType", (Object)this.physicalConnectorTypeAsString()).add("PhysicalNetworkInterfaceId", (Object)this.physicalNetworkInterfaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultGateway": {
                return Optional.ofNullable(clazz.cast(this.defaultGateway()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ipAddressAssignment": {
                return Optional.ofNullable(clazz.cast(this.ipAddressAssignmentAsString()));
            }
            case "macAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "netmask": {
                return Optional.ofNullable(clazz.cast(this.netmask()));
            }
            case "physicalConnectorType": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectorTypeAsString()));
            }
            case "physicalNetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.physicalNetworkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("defaultGateway", DEFAULT_GATEWAY_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("ipAddressAssignment", IP_ADDRESS_ASSIGNMENT_FIELD);
        map.put("macAddress", MAC_ADDRESS_FIELD);
        map.put("netmask", NETMASK_FIELD);
        map.put("physicalConnectorType", PHYSICAL_CONNECTOR_TYPE_FIELD);
        map.put("physicalNetworkInterfaceId", PHYSICAL_NETWORK_INTERFACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhysicalNetworkInterface, T> g) {
        return obj -> g.apply((PhysicalNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultGateway;
        private String ipAddress;
        private String ipAddressAssignment;
        private String macAddress;
        private String netmask;
        private String physicalConnectorType;
        private String physicalNetworkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalNetworkInterface model) {
            this.defaultGateway(model.defaultGateway);
            this.ipAddress(model.ipAddress);
            this.ipAddressAssignment(model.ipAddressAssignment);
            this.macAddress(model.macAddress);
            this.netmask(model.netmask);
            this.physicalConnectorType(model.physicalConnectorType);
            this.physicalNetworkInterfaceId(model.physicalNetworkInterfaceId);
        }

        public final String getDefaultGateway() {
            return this.defaultGateway;
        }

        public final void setDefaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
        }

        @Override
        public final Builder defaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getIpAddressAssignment() {
            return this.ipAddressAssignment;
        }

        public final void setIpAddressAssignment(String ipAddressAssignment) {
            this.ipAddressAssignment = ipAddressAssignment;
        }

        @Override
        public final Builder ipAddressAssignment(String ipAddressAssignment) {
            this.ipAddressAssignment = ipAddressAssignment;
            return this;
        }

        @Override
        public final Builder ipAddressAssignment(IpAddressAssignment ipAddressAssignment) {
            this.ipAddressAssignment(ipAddressAssignment == null ? null : ipAddressAssignment.toString());
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetmask() {
            return this.netmask;
        }

        public final void setNetmask(String netmask) {
            this.netmask = netmask;
        }

        @Override
        public final Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public final String getPhysicalConnectorType() {
            return this.physicalConnectorType;
        }

        public final void setPhysicalConnectorType(String physicalConnectorType) {
            this.physicalConnectorType = physicalConnectorType;
        }

        @Override
        public final Builder physicalConnectorType(String physicalConnectorType) {
            this.physicalConnectorType = physicalConnectorType;
            return this;
        }

        @Override
        public final Builder physicalConnectorType(PhysicalConnectorType physicalConnectorType) {
            this.physicalConnectorType(physicalConnectorType == null ? null : physicalConnectorType.toString());
            return this;
        }

        public final String getPhysicalNetworkInterfaceId() {
            return this.physicalNetworkInterfaceId;
        }

        public final void setPhysicalNetworkInterfaceId(String physicalNetworkInterfaceId) {
            this.physicalNetworkInterfaceId = physicalNetworkInterfaceId;
        }

        @Override
        public final Builder physicalNetworkInterfaceId(String physicalNetworkInterfaceId) {
            this.physicalNetworkInterfaceId = physicalNetworkInterfaceId;
            return this;
        }

        public PhysicalNetworkInterface build() {
            return new PhysicalNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhysicalNetworkInterface> {
        public Builder defaultGateway(String var1);

        public Builder ipAddress(String var1);

        public Builder ipAddressAssignment(String var1);

        public Builder ipAddressAssignment(IpAddressAssignment var1);

        public Builder macAddress(String var1);

        public Builder netmask(String var1);

        public Builder physicalConnectorType(String var1);

        public Builder physicalConnectorType(PhysicalConnectorType var1);

        public Builder physicalNetworkInterfaceId(String var1);
    }
}

