/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementAsyncClient;
import software.amazon.awssdk.services.snowdevicemanagement.model.DeviceSummary;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse;

public class ListDevicesPublisher
implements SdkPublisher<ListDevicesResponse> {
    private final SnowDeviceManagementAsyncClient client;
    private final ListDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicesPublisher(SnowDeviceManagementAsyncClient client, ListDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicesPublisher(SnowDeviceManagementAsyncClient client, ListDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceSummary> devices() {
        Function<ListDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevicesResponseFetcher
    implements AsyncPageFetcher<ListDevicesResponse> {
        private ListDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevicesResponse> nextPage(ListDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesPublisher.this.client.listDevices(ListDevicesPublisher.this.firstRequest);
            }
            return ListDevicesPublisher.this.client.listDevices((ListDevicesRequest)((Object)ListDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

