/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.ServerReplicationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerReplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerReplicationConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ServerReplicationConfiguration.getter(ServerReplicationConfiguration::server)).setter(ServerReplicationConfiguration.setter(Builder::server)).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()}).build();
    private static final SdkField<ServerReplicationParameters> SERVER_REPLICATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ServerReplicationConfiguration.getter(ServerReplicationConfiguration::serverReplicationParameters)).setter(ServerReplicationConfiguration.setter(Builder::serverReplicationParameters)).constructor(ServerReplicationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverReplicationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD, SERVER_REPLICATION_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Server server;
    private final ServerReplicationParameters serverReplicationParameters;

    private ServerReplicationConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.serverReplicationParameters = builder.serverReplicationParameters;
    }

    public Server server() {
        return this.server;
    }

    public ServerReplicationParameters serverReplicationParameters() {
        return this.serverReplicationParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.server());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverReplicationParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerReplicationConfiguration)) {
            return false;
        }
        ServerReplicationConfiguration other = (ServerReplicationConfiguration)obj;
        return Objects.equals(this.server(), other.server()) && Objects.equals(this.serverReplicationParameters(), other.serverReplicationParameters());
    }

    public String toString() {
        return ToString.builder((String)"ServerReplicationConfiguration").add("Server", (Object)this.server()).add("ServerReplicationParameters", (Object)this.serverReplicationParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "server": {
                return Optional.ofNullable(clazz.cast(this.server()));
            }
            case "serverReplicationParameters": {
                return Optional.ofNullable(clazz.cast(this.serverReplicationParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerReplicationConfiguration, T> g) {
        return obj -> g.apply((ServerReplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Server server;
        private ServerReplicationParameters serverReplicationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerReplicationConfiguration model) {
            this.server(model.server);
            this.serverReplicationParameters(model.serverReplicationParameters);
        }

        public final Server.Builder getServer() {
            return this.server != null ? this.server.toBuilder() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        public final ServerReplicationParameters.Builder getServerReplicationParameters() {
            return this.serverReplicationParameters != null ? this.serverReplicationParameters.toBuilder() : null;
        }

        @Override
        public final Builder serverReplicationParameters(ServerReplicationParameters serverReplicationParameters) {
            this.serverReplicationParameters = serverReplicationParameters;
            return this;
        }

        public final void setServerReplicationParameters(ServerReplicationParameters.BuilderImpl serverReplicationParameters) {
            this.serverReplicationParameters = serverReplicationParameters != null ? serverReplicationParameters.build() : null;
        }

        public ServerReplicationConfiguration build() {
            return new ServerReplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerReplicationConfiguration> {
        public Builder server(Server var1);

        default public Builder server(Consumer<Server.Builder> server) {
            return this.server((Server)((Server.Builder)Server.builder().applyMutation(server)).build());
        }

        public Builder serverReplicationParameters(ServerReplicationParameters var1);

        default public Builder serverReplicationParameters(Consumer<ServerReplicationParameters.Builder> serverReplicationParameters) {
            return this.serverReplicationParameters((ServerReplicationParameters)((ServerReplicationParameters.Builder)ServerReplicationParameters.builder().applyMutation(serverReplicationParameters)).build());
        }
    }
}

