/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.ServerCatalogStatus;
import software.amazon.awssdk.services.sms.model.ServerListCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServersResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetServersResponse> {
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetServersResponse.getter(GetServersResponse::lastModifiedOn)).setter(GetServersResponse.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedOn").build()}).build();
    private static final SdkField<String> SERVER_CATALOG_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServersResponse.getter(GetServersResponse::serverCatalogStatusAsString)).setter(GetServersResponse.setter(Builder::serverCatalogStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCatalogStatus").build()}).build();
    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetServersResponse.getter(GetServersResponse::serverList)).setter(GetServersResponse.setter(Builder::serverList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServersResponse.getter(GetServersResponse::nextToken)).setter(GetServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_ON_FIELD, SERVER_CATALOG_STATUS_FIELD, SERVER_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final Instant lastModifiedOn;
    private final String serverCatalogStatus;
    private final List<Server> serverList;
    private final String nextToken;

    private GetServersResponse(BuilderImpl builder) {
        super(builder);
        this.lastModifiedOn = builder.lastModifiedOn;
        this.serverCatalogStatus = builder.serverCatalogStatus;
        this.serverList = builder.serverList;
        this.nextToken = builder.nextToken;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public ServerCatalogStatus serverCatalogStatus() {
        return ServerCatalogStatus.fromValue(this.serverCatalogStatus);
    }

    public String serverCatalogStatusAsString() {
        return this.serverCatalogStatus;
    }

    public List<Server> serverList() {
        return this.serverList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCatalogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServersResponse)) {
            return false;
        }
        GetServersResponse other = (GetServersResponse)((Object)obj);
        return Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.serverCatalogStatusAsString(), other.serverCatalogStatusAsString()) && Objects.equals(this.serverList(), other.serverList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetServersResponse").add("LastModifiedOn", (Object)this.lastModifiedOn()).add("ServerCatalogStatus", (Object)this.serverCatalogStatusAsString()).add("ServerList", this.serverList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "serverCatalogStatus": {
                return Optional.ofNullable(clazz.cast(this.serverCatalogStatusAsString()));
            }
            case "serverList": {
                return Optional.ofNullable(clazz.cast(this.serverList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServersResponse, T> g) {
        return obj -> g.apply((GetServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private Instant lastModifiedOn;
        private String serverCatalogStatus;
        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServersResponse model) {
            super(model);
            this.lastModifiedOn(model.lastModifiedOn);
            this.serverCatalogStatus(model.serverCatalogStatus);
            this.serverList(model.serverList);
            this.nextToken(model.nextToken);
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final String getServerCatalogStatusAsString() {
            return this.serverCatalogStatus;
        }

        @Override
        public final Builder serverCatalogStatus(String serverCatalogStatus) {
            this.serverCatalogStatus = serverCatalogStatus;
            return this;
        }

        @Override
        public final Builder serverCatalogStatus(ServerCatalogStatus serverCatalogStatus) {
            this.serverCatalogStatus(serverCatalogStatus.toString());
            return this;
        }

        public final void setServerCatalogStatus(String serverCatalogStatus) {
            this.serverCatalogStatus = serverCatalogStatus;
        }

        public final Collection<Server.Builder> getServerList() {
            return this.serverList != null ? (Collection)this.serverList.stream().map(Server::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server ... serverList) {
            this.serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder> ... serverList) {
            this.serverList(Stream.of(serverList).map(c -> (Server)((Server.Builder)Server.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetServersResponse build() {
            return new GetServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServersResponse> {
        public Builder lastModifiedOn(Instant var1);

        public Builder serverCatalogStatus(String var1);

        public Builder serverCatalogStatus(ServerCatalogStatus var1);

        public Builder serverList(Collection<Server> var1);

        public Builder serverList(Server ... var1);

        public Builder serverList(Consumer<Server.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

