/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.ServerValidationStrategy;
import software.amazon.awssdk.services.sms.model.UserDataValidationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerValidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerValidationConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("server").getter(ServerValidationConfiguration.getter(ServerValidationConfiguration::server)).setter(ServerValidationConfiguration.setter(Builder::server)).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()}).build();
    private static final SdkField<String> VALIDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationId").getter(ServerValidationConfiguration.getter(ServerValidationConfiguration::validationId)).setter(ServerValidationConfiguration.setter(Builder::validationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServerValidationConfiguration.getter(ServerValidationConfiguration::name)).setter(ServerValidationConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SERVER_VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverValidationStrategy").getter(ServerValidationConfiguration.getter(ServerValidationConfiguration::serverValidationStrategyAsString)).setter(ServerValidationConfiguration.setter(Builder::serverValidationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationStrategy").build()}).build();
    private static final SdkField<UserDataValidationParameters> USER_DATA_VALIDATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userDataValidationParameters").getter(ServerValidationConfiguration.getter(ServerValidationConfiguration::userDataValidationParameters)).setter(ServerValidationConfiguration.setter(Builder::userDataValidationParameters)).constructor(UserDataValidationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userDataValidationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD, VALIDATION_ID_FIELD, NAME_FIELD, SERVER_VALIDATION_STRATEGY_FIELD, USER_DATA_VALIDATION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerValidationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Server server;
    private final String validationId;
    private final String name;
    private final String serverValidationStrategy;
    private final UserDataValidationParameters userDataValidationParameters;

    private ServerValidationConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.validationId = builder.validationId;
        this.name = builder.name;
        this.serverValidationStrategy = builder.serverValidationStrategy;
        this.userDataValidationParameters = builder.userDataValidationParameters;
    }

    public final Server server() {
        return this.server;
    }

    public final String validationId() {
        return this.validationId;
    }

    public final String name() {
        return this.name;
    }

    public final ServerValidationStrategy serverValidationStrategy() {
        return ServerValidationStrategy.fromValue(this.serverValidationStrategy);
    }

    public final String serverValidationStrategyAsString() {
        return this.serverValidationStrategy;
    }

    public final UserDataValidationParameters userDataValidationParameters() {
        return this.userDataValidationParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.server());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverValidationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userDataValidationParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerValidationConfiguration)) {
            return false;
        }
        ServerValidationConfiguration other = (ServerValidationConfiguration)obj;
        return Objects.equals(this.server(), other.server()) && Objects.equals(this.validationId(), other.validationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverValidationStrategyAsString(), other.serverValidationStrategyAsString()) && Objects.equals(this.userDataValidationParameters(), other.userDataValidationParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ServerValidationConfiguration").add("Server", (Object)this.server()).add("ValidationId", (Object)this.validationId()).add("Name", (Object)this.name()).add("ServerValidationStrategy", (Object)this.serverValidationStrategyAsString()).add("UserDataValidationParameters", (Object)this.userDataValidationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "server": {
                return Optional.ofNullable(clazz.cast(this.server()));
            }
            case "validationId": {
                return Optional.ofNullable(clazz.cast(this.validationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.serverValidationStrategyAsString()));
            }
            case "userDataValidationParameters": {
                return Optional.ofNullable(clazz.cast(this.userDataValidationParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("server", SERVER_FIELD);
        map.put("validationId", VALIDATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverValidationStrategy", SERVER_VALIDATION_STRATEGY_FIELD);
        map.put("userDataValidationParameters", USER_DATA_VALIDATION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerValidationConfiguration, T> g) {
        return obj -> g.apply((ServerValidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Server server;
        private String validationId;
        private String name;
        private String serverValidationStrategy;
        private UserDataValidationParameters userDataValidationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerValidationConfiguration model) {
            this.server(model.server);
            this.validationId(model.validationId);
            this.name(model.name);
            this.serverValidationStrategy(model.serverValidationStrategy);
            this.userDataValidationParameters(model.userDataValidationParameters);
        }

        public final Server.Builder getServer() {
            return this.server != null ? this.server.toBuilder() : null;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final String getValidationId() {
            return this.validationId;
        }

        public final void setValidationId(String validationId) {
            this.validationId = validationId;
        }

        @Override
        public final Builder validationId(String validationId) {
            this.validationId = validationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getServerValidationStrategy() {
            return this.serverValidationStrategy;
        }

        public final void setServerValidationStrategy(String serverValidationStrategy) {
            this.serverValidationStrategy = serverValidationStrategy;
        }

        @Override
        public final Builder serverValidationStrategy(String serverValidationStrategy) {
            this.serverValidationStrategy = serverValidationStrategy;
            return this;
        }

        @Override
        public final Builder serverValidationStrategy(ServerValidationStrategy serverValidationStrategy) {
            this.serverValidationStrategy(serverValidationStrategy == null ? null : serverValidationStrategy.toString());
            return this;
        }

        public final UserDataValidationParameters.Builder getUserDataValidationParameters() {
            return this.userDataValidationParameters != null ? this.userDataValidationParameters.toBuilder() : null;
        }

        public final void setUserDataValidationParameters(UserDataValidationParameters.BuilderImpl userDataValidationParameters) {
            this.userDataValidationParameters = userDataValidationParameters != null ? userDataValidationParameters.build() : null;
        }

        @Override
        public final Builder userDataValidationParameters(UserDataValidationParameters userDataValidationParameters) {
            this.userDataValidationParameters = userDataValidationParameters;
            return this;
        }

        public ServerValidationConfiguration build() {
            return new ServerValidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerValidationConfiguration> {
        public Builder server(Server var1);

        default public Builder server(Consumer<Server.Builder> server) {
            return this.server((Server)((Server.Builder)Server.builder().applyMutation(server)).build());
        }

        public Builder validationId(String var1);

        public Builder name(String var1);

        public Builder serverValidationStrategy(String var1);

        public Builder serverValidationStrategy(ServerValidationStrategy var1);

        public Builder userDataValidationParameters(UserDataValidationParameters var1);

        default public Builder userDataValidationParameters(Consumer<UserDataValidationParameters.Builder> userDataValidationParameters) {
            return this.userDataValidationParameters((UserDataValidationParameters)((UserDataValidationParameters.Builder)UserDataValidationParameters.builder().applyMutation(userDataValidationParameters)).build());
        }
    }
}

